#include <QtGui/qpainter.h>
#include <QSettings>
#include <QAction>
#include <QDebug>

#include "qflipclock-widget.h"
#include "widgetsettings.h"
#include "config.h"

QFlipClock_Widget::QFlipClock_Widget()
        : QFlipClock()
{
    setAttribute(Qt::WA_TranslucentBackground);

    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    resize(
            settings.value("Main/Width", DEFAULT_WIDTH).toInt(),
            settings.value("Main/Height", DEFAULT_HEIGHT).toInt()
            );
    setTransition(TransitionsEnum(
            settings.value("Main/Transition", Transition_Flip).toInt()));

    QAction *settingsAction = new QAction(tr("&Settings"), this);
    connect(settingsAction, SIGNAL(triggered()), SLOT(showSettingsDialog()));

#if !defined(Q_OS_SYMBIAN) && !defined(Q_WS_MAEMO_5)
    addAction(settingsAction);
    setContextMenuPolicy(Qt::ActionsContextMenu);
#endif
}

QSize QFlipClock_Widget::sizeHint() const
{
    return 2 * QFlipClock::sizeHint();
}

void QFlipClock_Widget::showSettingsDialog()
{
    WidgetSettings dlg;
    if (dlg.exec() == QDialog::Accepted)
    {
        setNewSize(dlg.getSize());
        setNewTransition(dlg.getTransition());
        setNewTheme(dlg.getTheme());
        setNewClickAction(dlg.getClickAction());
        dlg.close();
    }
}

/*
 * Hook for homescreenChanged signal.
 * Stop the timer when homescreen is hidden,
 * and resume on homescreen is shown.
 * It also handles screen lock/unlock events.
 */
void QFlipClock_Widget::homescreenChangedHook(
                        bool isCurrentHomescreen)
{
    if (isCurrentHomescreen)
    {
        updateTime(true);
        startTimer();
    }
    else
    {
        stopTimer();
    }
}

void QFlipClock_Widget::setNewSize(QSize const& size)
{
    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    int _width = (size.width() > MIN_WIDTH && size.width() < MAX_WIDTH) ? size.width() : DEFAULT_WIDTH;
    int _height = (size.height() > MIN_HEIGHT && size.height() < MAX_HEIGHT) ? size.height() : DEFAULT_HEIGHT;
    settings.setValue("Main/Width", _width);
    settings.setValue("Main/Height", _height);
    resize(_width, _height);
}

void QFlipClock_Widget::setNewTransition(TransitionsEnum transition)
{
    QSettings  settings(ORGANIZATION_NAME, APPLICATION_NAME);
    settings.setValue("Main/Transition", transition);
    setTransition(transition);
}

void QFlipClock_Widget::setNewTheme(QString name)
{
    QSettings  settings(ORGANIZATION_NAME, APPLICATION_NAME);
    settings.setValue("Main/Theme", name);
    settings.sync();
    updateTheme();
    repaint();
}

void QFlipClock_Widget::setNewClickAction(ActionEnum action)
{
    QSettings  settings(ORGANIZATION_NAME, APPLICATION_NAME);
    settings.setValue("Main/ClickAction", action);
    setClickAction(action);
}
