#include "listwindow.h"
#include <QtGui>
#include <QtDebug>

ListWindow::ListWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    xml = new XML();

    model = new QStandardItemModel(this);

    lstExercises = new QListView();
    lstExercises->setModel(model);

    connect(lstExercises,SIGNAL(clicked(QModelIndex)),this,SLOT(showInfo(QModelIndex)));
    lstExercises->setContextMenuPolicy(Qt::CustomContextMenu);
    connect(lstExercises, SIGNAL(customContextMenuRequested(const QPoint &)),SLOT(showContextMenuForWidget(const QPoint &)));


    createActions();
    createMenu();

    setCentralWidget(lstExercises);

}

void ListWindow::sendLandscape()
{
    emit landscape();
}

void ListWindow::sendClosed()
{
    emit closed();
}

void ListWindow::changeEvent(QEvent *event)
{
    if(event->type() == QEvent::ActivationChange)
        loadExercises(group);
}

void ListWindow::loadExercises(QString grp)
{
    QList <QString> list;
    group = grp;
    if(grp == "Cardio")
        list = xml->openCardio();
    else if(grp == "Program")
        list = xml->getPrograms();
    else
        list = xml->openGroup(grp);

    model->clear();
    lstExercises->setSelectionMode(QListView::SingleSelection);
    if(list.isEmpty())
    {
        if(grp == "Program")
            model->appendRow(new QStandardItem ("No programs"));
        else
            model->appendRow(new QStandardItem ("No exercises"));

        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }

    model->sort(0);
}

void ListWindow::showInfo(QModelIndex index)
{
    if(index.data().toString() == "No exercises" || index.data().toString() == "No programs")
        return;

    if(group == "Program")
    {
        piw = new ProgramInfoWindow(this);
        piw->load(index.data().toString());
        piw->show();
    }
    else if(group !=  "Cardio")
    {
        iw = new InfoWindow(this);
        connect(iw,SIGNAL(closed()),this,SLOT(sendClosed()));
        connect(iw,SIGNAL(landscape()),this, SLOT(sendLandscape()));

        iw->loadExercise(index.data().toString());
        iw->show();
    }
    else
    {

        imw = new InfoMotionWindow(this);
        connect(imw,SIGNAL(closed()),this,SLOT(sendClosed()));
        connect(imw,SIGNAL(landscape()),this, SLOT(sendLandscape()));
        imw->loadMotionExercise(index.data().toString());
        imw->show();
    }
}

void ListWindow::showNewIngredient()
{
    niw = new NewIngredientWindow(this);
    niw->load();
    niw->show();
}

void ListWindow::showHistory()
{
    hw = new HistoryWindow(this);
    hw->load();
    hw->show();
}

void ListWindow::showSettings()
{
    sw = new SettingsWindow(this);
    sw->show();
}

void ListWindow::showNewExercise()
{
    nw = new NewExerciseWindow(this);

    emit landscape();
    connect(nw,SIGNAL(closed()),this,SLOT(sendClosed()));

    nw->load();
    nw->show();
}

void ListWindow::showNewProgram()
{
    npw = new NewProgramWindow(this);
    npw->load();
    npw->show();
}

void ListWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
    menu->addAction(importAction);
}

void ListWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);
    importAction = new QAction("Import exercises",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));
    connect(importAction,SIGNAL(triggered()),this, SLOT(import()));


}

void ListWindow::showContextMenuForWidget(const QPoint &pos)
{

    QMenu contextMenu(this);
    QAction *editItemAction = new QAction("Edit", this);
    QAction *deleteItemAction = new QAction("Remove", this);
    if(group != "Program")
    {

        QAction *exportAction = new QAction("Export",this);
        connect(exportAction,SIGNAL(triggered()),this, SLOT(showExport()));
        contextMenu.addAction(exportAction);
    }
    connect(editItemAction, SIGNAL(triggered()), this, SLOT(editItem()));
    connect(deleteItemAction, SIGNAL(triggered()), this, SLOT(deleteItem()));



    contextMenu.addAction(editItemAction);
    contextMenu.addAction(deleteItemAction);
    contextMenu.exec(mapToGlobal(pos));
}

void ListWindow::deleteItem()
{
    QString str;

    str = lstExercises->currentIndex().data().toString();

    for(int i = 0; i < model->rowCount();i++)
    {
        if(model->index(i,0).data().toString() == str)
            model->removeRow(i);
    }

    QMessageBox msgBox;
     msgBox.setText("Do you really want to remove " + str);
     msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
     msgBox.setDefaultButton(QMessageBox::Cancel);
     int ret = msgBox.exec();

     if(ret == QMessageBox::Ok)
     {
         if(group != "Cardio" && group != "Program")
            xml->removeElement(str,"exercises");
         else if(group == "Cardio")
            xml->removeElement(str,"cardio");
         else if (group == "Program")
             xml->removeProgram(str);
     }
}

void ListWindow::editItem()
{
    QString str;
    QList <QString> list;
    str = lstExercises->currentIndex().data().toString();

    if(group == "Program")
    {
        list = xml->loadProgram(str);
        npw = new NewProgramWindow(this);
        npw->load(str,list);
        npw->show();
    }
    else
    {
        list = xml->openEx(str);
        nw = new NewExerciseWindow(this);
        nw->load(list.takeFirst(),list.takeFirst(),list.takeFirst(),list.takeFirst());
        nw->show();
    }
}

void ListWindow::showExport()
{
    ew = new ExportWindow(this);
    ew->loadExercises(group);
    ew->show();
}

void ListWindow::import()
{

    QString s = QFileDialog::getOpenFileName(this,"Choose a file","/home/user/MyDocs","XML files (*.xml)");

    xml->import(s);
}
