#include "exercisewindow.h"
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#include <QDBusMessage>
#include <QDebug>



ExerciseWindow::ExerciseWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    widget = new QWidget();

    mx = 0; my = 0; mz = 0;
    proximity = false;

    xml = new XML();

    vLayout = new QVBoxLayout;

    QFont font;
    font.setPointSize(32);

    label = new QLabel("");
    label->setAlignment(Qt::AlignCenter);
    label->setFont(font);


    btnShake = new QPushButton("Done");
    connect(btnShake,SIGNAL(clicked()),this,SLOT(shaked()));

    vLayout->addWidget(label);
    vLayout->addWidget(btnShake);


    widget->setLayout(vLayout);
    setCentralWidget(widget);
    createActions();
    createMenu();

    timer = new QTimer(this);
    QObject::connect(timer, SIGNAL(timeout()), this, SLOT(updateTime()));

    myThread = new aThread(this);
    connect(myThread, SIGNAL(deviceOrientation(QString, QString, QString)),
            this, SLOT(checkAcc(QString)));
    connect(myThread, SIGNAL(proximityState(QString)),
            this, SLOT(checkProximity(QString)));


    interface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                                   MCE_REQUEST_IF, QDBusConnection::systemBus(),
                                   this);

    pause = QDBusMessage::createMethodCall("com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer",
                                           "/com/nokia/mafw/renderer/gstrenderer",
                                           "com.nokia.mafw.renderer",
                                           "pause");

    resume = QDBusMessage::createMethodCall("com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer",
                                            "/com/nokia/mafw/renderer/gstrenderer",
                                            "com.nokia.mafw.renderer",
                                            "resume");


    QDBusMessage reply = interface->call(MCE_ENABLE_VIBRATOR);
    if (reply.type() == QDBusMessage::ErrorMessage)
        qDebug() << reply.errorMessage();

    //reply = interface->call(MCE_TKLOCK_MODE_CHANGE_REQ, "MCE_TK_LOCKED");


    sound = new PlaySound();

}

void ExerciseWindow::sendClosed()
{
    emit closed();
}

void ExerciseWindow::loadExercise(QList<QString> name)
{
    qDebug () << "ExerciseWindow::loadExercise 1";
    int i = 0;
    QList <QString> list = xml->getHistoryByExercise(name.first());

    while(!list.isEmpty())
    {
        status[i] = list.takeFirst();
        reps[i] = list.takeFirst();
        weight[i] = list.takeFirst();

        i++;
    }
    currentSet = 0;
    qDebug () << "ExerciseWindow::loadExercise 2";
    bool firstTime = false;
    if(exercises.count() == 0)
        firstTime = true;

    exercises = name;

    QList <QString> tmp;
    QList<QString> settings = xml->loadSettings();
    qDebug () << "ExerciseWindow::loadExercise 3";
    settings.removeLast();
    SEC = settings.takeLast().toInt();
    MIN = settings.takeLast().toInt();

    SET = settings.takeLast().toInt();

    vibrateActive = false; soundActive = false;
    if(settings.takeFirst() == "1")
        vibrateActive = true;
    if(settings.takeFirst() == "1")
        soundActive = true;

    qDebug () << "ExerciseWindow::loadExercise 4";
    if(exercises.count() == 1)
    {
        currentExercise = exercises.first();

        tmp = xml->openEx(currentExercise);
        tmp.removeFirst();
        currentGroup = tmp.takeFirst();
        qDebug () << "ExerciseWindow::loadExercise 5";
        set = SET; min = MIN; sec = SEC;
        strSet.setNum(SET); strMin.setNum(MIN);  strSec.setNum(SEC);

        wdCount = 2;

        if(weight[currentSet] != "")
            label->setText("Exercise: " + currentExercise +  "\nShake when set is done." +
                           "\nLast time on this set: " + weight[currentSet] + "x"  +
                           reps[currentSet] + " was " + status[currentSet] + ".");
        else
            label->setText("Exercise: " + currentExercise +  "\nShake when set is done.");

        btnShake->setEnabled(true);
        myThread->start(QThread::NormalPriority);
        qDebug () << "ExerciseWindow::loadExercise 6";
    }

    if(firstTime == true && exercises.count() > 1)
    {
        qDebug () << "ExerciseWindow::loadExercise 7";
        ed = new ExerciseDialog(this);
        connect(ed,SIGNAL(exerciseName(QString)),this, SLOT(setCurrentExercise(QString)));
        connect(ed,SIGNAL(destroyDialog()),this,SLOT(sendDestroyDialog()));
        ed->load(exercises);
        qDebug () << "ExerciseWindow::loadExercise 8";
        ed->show();
        qDebug () << "ExerciseWindow::loadExercise 9";
    }


}

void ExerciseWindow::sendDestroyDialog()
{
    ed->~ExerciseDialog();
}

void ExerciseWindow::openED()
{
    qDebug () << "ExerciseWindow::openED 1";
    if(exercises.count() > 1)
    {
        qDebug () << "ExerciseWindow::openED 2";
        ed = new ExerciseDialog(this);
        connect(ed,SIGNAL(exerciseName(QString)),this, SLOT(setCurrentExercise(QString)));
        qDebug () << "ExerciseWindow::openED 3";
        connect(ed,SIGNAL(destroyDialog()),this,SLOT(sendDestroyDialog()));
        ed->load(exercises);
        qDebug () << "ExerciseWindow::openED 4";
        ed->show();
    }
}

void ExerciseWindow::setCurrentExercise(QString name)
{
    qDebug () << "ExerciseWindow::setCurrentExercise 1";
    int i = 0;
    QList <QString> list;

    currentSet = 0;

    list = xml->getHistoryByExercise(name);
    qDebug () << "ExerciseWindow::setCurrentExercise 2";
    while(!list.isEmpty())
    {
        status[i] = list.takeFirst();
        reps[i] = list.takeFirst();
        weight[i] = list.takeFirst();

        i++;
    }
    qDebug () << "ExerciseWindow::setCurrentExercise 3";
    QList <QString> tmp;
    currentExercise = name;
    QDBusMessage reply;

    tmp = xml->openEx(currentExercise);
    tmp.removeFirst();
    currentGroup = tmp.takeFirst();
    qDebug () << "ExerciseWindow::setCurrentExercise 4";

    set = SET; min = MIN; sec = SEC;
    strSet.setNum(SET); strMin.setNum(MIN);  strSec.setNum(SEC);

    wdCount = 2;

    if(weight[currentSet] != "")
        label->setText("Exercise: " + currentExercise +  "\nShake when set is done." +
                       "\nLast time on this set: " + weight[currentSet] + "x"  +
                       reps[currentSet] + " was " + status[currentSet] + ".");
    else
        label->setText("Exercise: " + currentExercise +  "\nShake when set is done.");
    qDebug () << "ExerciseWindow::setCurrentExercise 5";
    btnShake->setEnabled(true);
    myThread->start(QThread::NormalPriority);


    reply = interface->call(MCE_TKLOCK_MODE_CHANGE_REQ, "locked");
    qDebug () << "ExerciseWindow::setCurrentExercise 6";
}

void ExerciseWindow::changeEvent(QEvent *event)
{
    this->update();
}

void ExerciseWindow::showNewIngredient()
{
    niw = new NewIngredientWindow(this);
    niw->load();
    niw->show();
}

void ExerciseWindow::showHistory()
{
    hw = new HistoryWindow(this);
    hw->load();
    hw->show();
}

void ExerciseWindow::showSettings()
{
    sw = new SettingsWindow(this);
    sw->show();
}

void ExerciseWindow::showNewExercise()
{
    nw = new NewExerciseWindow(this);
    emit landscape();
    connect(nw,SIGNAL(closed()),this,SLOT(sendClosed()));
    nw->load();
    nw->show();
}

void ExerciseWindow::showNewProgram()
{
    npw = new NewProgramWindow(this);
    npw->load();
    npw->show();
}

void ExerciseWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
    menu->addAction(skipAction);
}

void ExerciseWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);
    skipAction = new QAction("Skip wait", this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));
    connect(skipAction,SIGNAL(triggered()), this, SLOT(skipWait()));
}

void ExerciseWindow::updateTime()
{
    qDebug () << "updateTime 1";
    //count down wait
    strMin.setNum(min); strSec.setNum(sec); strSet.setNum(set);
    QString str = strMin + ":" + strSec + " rest left (" + strSet + "set)";
    btnShake->setEnabled(false);
    label->setText(str);
    qDebug () << "updateTime 2";
    if(sec <= 0)
    {
        sec = 60;
        min--;
        if(min == -1)
        {
            //wait is over

            if(weight[currentSet] != "")
                label->setText("Exercise: " + currentExercise +  "\nShake when set is done." +
                               "\nLast time on this set: " + weight[currentSet] + "x"  +
                               reps[currentSet] + " was " + status[currentSet] + ".");
            else
                label->setText("Exercise: " + currentExercise +  "\nShake when set is done.");

            btnShake->setEnabled(true);

            qDebug () << "updateTime 3";

            timer->stop();

            if(soundActive == true)
            {
                //if(music playing)
                QDBusConnection::sessionBus().send(pause);
                tmrPause = new QTimer(this);
                tmrPause->setSingleShot(true);
                QObject::connect(tmrPause, SIGNAL(timeout()), this, SLOT(resumeMusic()));
                tmrPause->start(3000);  //ndra hr fr olika vibrationslngd
                sound->playWait();

            }
            qDebug () << "updateTime 4";
            myThread->start(QThread::NormalPriority);

            if(vibrateActive == true)
            {
                vibrate();
                tmr = new QTimer(this);
                tmr->setSingleShot(true);
                QObject::connect(tmr, SIGNAL(timeout()), this, SLOT(stopVibrate()));
                tmr->start(3000);  //ndra hr fr olika vibrationslngd
            }
            qDebug () << "updateTime 5";
        }
    }
    sec--;

}

void ExerciseWindow::resumeMusic()
{
    QDBusConnection::sessionBus().send(resume);
}

void ExerciseWindow::skipWait()
{
    min = 0;
    sec = 0;
}

void ExerciseWindow::checkProximity(QString data)
{
    if(data.left(6) == "closed")
    {
        proximity = true;
    }
    else
    {
        proximity = false;
    }

}

void ExerciseWindow::checkAcc(QString x)
{

    qDebug () << "checkAcc 1";
    if(x.toInt() > 2200 || x.toInt() < -2200)
    {
        if(proximity == false)
        {
            vibrate();
            tmr = new QTimer(this);
            tmr->setSingleShot(true);
            QObject::connect(tmr, SIGNAL(timeout()), this, SLOT(stopVibrate()));
            tmr->start(1000);  //ndra hr fr olika vibrationslngd
            qDebug () << "checkAcc 2";
            shaked();
        }

    }

}

void ExerciseWindow::shaked()
{
    qDebug () << "shaked 1";
    currentSet++;
    QDBusMessage reply;
    if(set == -1)
        return;

    min = MIN; sec = SEC;

    set--;

    if(set == 0)
    {
        qDebug () << "shaked 2";
        timer->stop();
        if(soundActive == true)
        {
            qDebug () << "shaked 3";
            QDBusConnection::sessionBus().send(pause);
            tmrPause = new QTimer(this);
            tmrPause->setSingleShot(true);
            QObject::connect(tmrPause, SIGNAL(timeout()), this, SLOT(resumeMusic()));
            tmrPause->start(3000);  //ndra hr fr olika vibrationslngd
            sound->playDone();
            qDebug () << "shaked 4";
            //wait x ms
            //QDBusConnection::sessionBus().send(resume);

        }

        if(exercises.count() > 1)
        {
            qDebug () << "shaked 5";
            exercises.removeOne(currentExercise);
            loadExercise(exercises);

            wd = new WeightDialog(this);
            connect(wd,SIGNAL(next()),this,SLOT(reopenWD()));
            qDebug () << "shaked 6";
            wd->load(currentExercise, currentGroup,"1");
            wd->show();
            qDebug () << "shaked 7";
            return;

        }
        else
        {
            label->setText("Exercise(s) completed!");
            btnShake->setEnabled(false);
            qDebug () << "shaked 8";
            wd = new WeightDialog(this);
            connect(wd,SIGNAL(next()),this,SLOT(reopenWD()));
            qDebug () << "shaked 9";
            wd->load(currentExercise, currentGroup,"1");
            wd->show();
            qDebug () << "shaked 10";
            return;
        }
        qDebug () << "shaked 11";
        wd = new WeightDialog(this);
        connect(wd,SIGNAL(next()),this,SLOT(reopenWD()));
        qDebug () << "shaked 12";
        wd->load(currentExercise, currentGroup, "1");
        wd->show();
        qDebug () << "shaked 13";
    }

    //Start wait and count down
    strMin.setNum(min); strSec.setNum(sec); strSet.setNum(set);
    QString str = strMin + ":" + strSec + " rest left (" + strSet + "set)";
    label->setText(str);
    btnShake->setEnabled(false);

    qDebug () << "shaked 14";
    reply = interface->call(MCE_TKLOCK_MODE_CHANGE_REQ, "locked");

    timer->start(1000); //count down every second
    myThread->quit(); //stop check accelerometer
    qDebug () << "shaked 15";
}

void ExerciseWindow::reopenWD()
{
    QString str;
    qDebug () << "reopenWD 1";
    if(wdCount > SET)
    {
        qDebug () << "reopenWD 2";
        if(exercises.count() > 1)
        {
            qDebug () << "reopenWD 3";
            openED();
        }
        return;
    }
    else
    {
        qDebug () << "reopenWD 4";
        str.setNum(wdCount);
        wd = new WeightDialog(this);
        wd->load(currentExercise, currentGroup, str);
        qDebug () << "reopenWD 5";
        connect(wd,SIGNAL(next()),this,SLOT(reopenWD()));
        wd->show();
        qDebug () << "reopenWD 6";
    }

    wdCount++;
    qDebug () << "reopenWD 7";
}


void ExerciseWindow::vibrate()
{
    QDBusMessage reply;

    reply = interface->call(MCE_ACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
    if (reply.type() == QDBusMessage::ErrorMessage)
        qDebug() << reply.errorMessage();
}

void ExerciseWindow::stopVibrate()
{
    QDBusMessage reply;

    reply = interface->call(MCE_DEACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
    if (reply.type() == QDBusMessage::ErrorMessage)
        qDebug() << reply.errorMessage();
}

void ExerciseWindow::closeEvent(QCloseEvent *event)
{
    myThread->quit();
    timer->stop();
}
