#include <QFile>
#include <QTextStream>
#include <QTimer>
#include <QStringList>
#include <QDebug>
#include "athread.h"

aThread::aThread(QObject *parent)
    : QThread(parent)
{
}

void aThread::run()
{
    QTimer timer;
    connect(&timer, SIGNAL(timeout()), this, SLOT(update()));
    timer.start(50); // 50 Hz update rate

    exec();
}
void aThread::update()
{
    updateCoords();
    readProximity();
}

void aThread::updateCoords()
{
     QFile file("/sys/class/i2c-adapter/i2c-3/3-001d/coord");
     if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
         return;
     QTextStream in(&file);
     QString data = in.readAll();
     processCoords(data);
}

void aThread::readProximity()
{
    QFile file("/sys/devices/platform/gpio-switch/proximity/state");
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return;
    QTextStream in(&file);
    QString data = in.readAll();
    emit proximityState(data);
}


void aThread::processCoords(QString &data)
{
    QStringList data_splited = data.split(" ");

    x = data_splited[0];
    y = data_splited[1];
    z = data_splited[2];

    emit deviceOrientation(x, y, z);
}

