#ifndef WEIGHTDIALOG_H
#define WEIGHTDIALOG_H

#include <QtGui>
#include "xml.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

class WeightDialog : public QDialog
{
    Q_OBJECT

public:
    explicit WeightDialog(QWidget *parent = 0);
    void load(QString name, QString grp, QString currentSet);
    void loadCardio(QString name, QString m, QString s);

signals:
    void next();

private slots:
    void save();

private:
    XML *xml;

    void closeEvent(QCloseEvent *event);

    QRadioButton *radioEasy;
    QRadioButton *radioOK;
    QRadioButton *radioHard;

    QPushButton *btnSave;

    QStandardItemModel *modelReps;
    QStandardItemModel *modelVar;

    QMaemo5ValueButton *btnReps;
    QMaemo5ValueButton *btnVar;

    QMaemo5ListPickSelector *selectorReps;
    QMaemo5ListPickSelector *selectorVar;

    QHBoxLayout *hLayout;
    QVBoxLayout *buttonLayout;

    QString group;
    QString exName;
    QString reps, set;
    QString min, sec;
    bool close;
};
#endif // WEIGHTDIALOG_H
