#include "xml.h"
#include <QDateTime>
#include <QtXml>
#include <QMessageBox>
#include <QtDebug>
#include <QtGui/QApplication>

XML::XML()
{

}


void XML::removeElement(QString name, QString filename)
{

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise/";
    str.append(filename);
    QFile file( str + ".xml" );

    if( !file.open( QIODevice::ReadOnly ) )
      return;


    if( !doc.setContent( &file ) )
    {
      file.close();
      return;
    }
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
      return;

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {
                root.removeChild(n);
            }
        }
      }
      n = n.nextSibling();
  }
    if( !file.open( QIODevice::WriteOnly ) )
      return;
    QTextStream ts( &file );
    ts << doc.toString();

    file.close();
}

void XML::removeIngredient(QString name)
{
    return;
}

void XML::removeProgram(QString name)
{

    QDomDocument doc( "Program" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/program.xml" );
    if( !file.open( QIODevice::ReadWrite ) )
    {
        return;
    }
    qDebug() << "XML::removeProgram 1";
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "programs" )
    {
      return;
    }
    qDebug() << "XML::removeProgram 2";
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "program" )
        {

            if(name == e.attribute( "name", "" ))
            {
                root.removeChild(n);
                qDebug() << "XML::removeProgram 3";
            }
        }
      }
      n = n.nextSibling();
   }
    if( !file.open( QIODevice::WriteOnly ) )
      return;
    QTextStream ts( &file );
    ts << doc.toString();

    file.close();
}

void XML::removeHistory(QString name, QString date)
{
    qDebug() << "XML::removeHistory" << name << " " << date;
    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/history.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return;
    }
    doc.setContent(&file);
    file.close();
    qDebug() << "XML::removeHistory 1";
    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        return;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(e.attribute("name", "") == name && date == "0")
            {
                qDebug() << "XML::removeHistory 2";
                date = e.attribute("date", "");
            }

            if(e.attribute("name", "") == name)
            {
                if( e.attribute("date", "") == date)
                {
                    qDebug() << "XML::removeHistory 3";
                    root.removeChild(n);
                }
            }
        }

      }

      n = n.nextSibling();
   }

    if( !file.open( QIODevice::WriteOnly ) )
      return;
    QTextStream ts( &file );
    ts << doc.toString();

    file.close();
}

void XML::saveProgram(QString name, QModelIndexList exercises)
{
    qDebug() << exercises;

    QDomDocument doc( "Program" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/program.xml" );
    file.open( QIODevice::ReadWrite );
    doc.setContent( &file );

    file.close();


    //leta efter ett program med samma namn, isf ta bort den
    QDomElement root = doc.documentElement();


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "programs" )
        {
            qDebug () << "XML::saveProgram" << e.attribute( "name", "" );
            if(name == e.attribute( "name", "" ))
            {
                qDebug() << "XML::saveProgram: remove";
                removeProgram(name);
            }
        }
      }
      n = n.nextSibling();
   }
   QTextStream ts( &file );
   ts << doc.toString();

   doc.clear();
   file.open( QIODevice::ReadWrite );
   doc.setContent( &file );
   file.remove();
   root = doc.documentElement();
    if( root.tagName() != "programs" )
    {
        root = doc.createElement( "programs" );
        doc.appendChild( root );
        qDebug() << "XML::saveProgram: create root";
    }

    file.remove();
    file.close();
    root.appendChild(createProgramNode(doc, name, exercises));

    if(!file.open(QIODevice::WriteOnly))
        return ;

    QTextStream ts2( &file );
    ts2 << doc.toString();

    file.close();

    return ;
}

/*QList <QString> XML::removeExistingExercises(QString name, QList <QString> exercises)
{
    QList <QString> list;
    bool found = false;
    QDomDocument doc( "Program" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/program.xml" );
    QString tal;

    file.open( QIODevice::ReadWrite );
    doc.setContent( &file );

    file.close();

    QDomElement root = doc.documentElement();


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "programs" )
        {
            if(name == e.attribute( "name", "" ))
            {
                for(int i = 0; i < exercises.count(); i++)
                {
                    found = false;
                    for(int j = 1; j < 20; j++)
                    {
                        tal.setNum(j);
                        if(exercises.at(i) == e.attribute("exercise" + tal, ""))
                        {
                            found = true;
                        }
                    }
                }
                if(found == true)
                    list.append(exercises.at(i));
            }
        }
      }
      n = n.nextSibling();
   }

    return list;
}*/

QDomElement XML::createProgramNode(QDomDocument &d, QString name, QModelIndexList exercises)
{
    QDomElement cn = d.createElement( "program" );
    QString tal;
    cn.setAttribute( "name", name );
    for(int i= 1; i < 20; i++)
    {
        tal.setNum(i);
        if(exercises.isEmpty())
            cn.setAttribute( "exercise" + tal, "" );
        else
            cn.setAttribute( "exercise" + tal, exercises.takeFirst().data().toString() );
    }

    return cn;
}

QList <QString> XML::loadProgram(QString name)
{
    QList <QString> readInfo;

    QDomDocument doc( "Program" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/program.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "programs" )
    {
      return readInfo;
    }

    QString tal;

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "program" )
        {

            if(name == e.attribute( "name", "" ))
            {
                for(int i = 1; i < 20; i++)
                {
                    tal.setNum(i);
                    readInfo.append(e.attribute("exercise"+tal, ""));
                }
            }
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

QList <QString> XML::getPrograms()
{
    QList<QString> readInfo;
    readInfo.clear();

    QDomDocument doc( "Program" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/program.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        readInfo.append("file");
      return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "programs" )
    {
        readInfo.append(root.tagName());
        return readInfo;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "program" )
        {
          readInfo.append(e.attribute("name", ""));
        }
      }
      n = n.nextSibling();
   }

    return readInfo;
}

void XML::saveSettings(QString vibrate, QString sound, QString volume,
                       QString set, QString min, QString sec, QString calories)
{
    QDomDocument doc( "Settings" );
    QDomElement root = doc.createElement( "setting" );
    doc.appendChild( root );

    root.appendChild(createSettingsNode(doc, vibrate, sound, volume, set, min, sec, calories));

    QString str = "/home/user/.qexercise";
    QFile file( str + "/settings.xml" );
    if(!file.open(QIODevice::WriteOnly))
        return;

    QTextStream ts( &file );
    ts << doc.toString();

    file.close();
    return;
}

QList <QString> XML::loadSettings()
{
    QList <QString> readInfo;

    QDomDocument doc( "Settings" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/settings.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return readInfo;
    }
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "setting" )
    {
        return readInfo;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "settings" )
        {

            readInfo.append(e.attribute("vibrate", ""));
            readInfo.append(e.attribute("sound", ""));
            readInfo.append(e.attribute("volume", ""));
            readInfo.append(e.attribute("set", ""));
            readInfo.append(e.attribute("min", ""));
            readInfo.append(e.attribute("sec", ""));
            readInfo.append(e.attribute("calories", ""));

        }
      }
      n = n.nextSibling();
   }

    return readInfo;
}

void XML::saveFirstSet(QString group, QString name, QString kg, QString reps, QString status)
{
    QDate date = QDate::currentDate();
    QString dateString = date.toString("dd-MM-yyyy");

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/history.xml" );
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );


    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        root = doc.createElement( "exercise" );
        doc.appendChild( root );
    }

    file.close();

    root.appendChild(createHistoryNode(doc, group, name, dateString, kg, reps, status));

    if(!file.open(QIODevice::WriteOnly))
        return ;

    QTextStream ts( &file );
    ts << doc.toString();

    file.close();

    return ;

}

void XML::updateHistory(QString name, QString set, QString kg, QString reps, QString status)
{
    QDate date = QDate::currentDate();
    QString dateString = date.toString("dd-MM-yyyy");

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/history.xml" );
    if( !file.open( QIODevice::ReadWrite ) )
      return;
    if( !doc.setContent( &file ) )
    {
      file.close();
      return;
    }
    file.remove();
    file.close();
    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
      return;

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ) && dateString == e.attribute("date",""))
            {
                e.setAttribute("variable" + set, kg);
                e.setAttribute("reps" + set, reps);
                e.setAttribute("status" + set, status);
            }
        }
      }
      n = n.nextSibling();
   }

    file.open( QIODevice::ReadWrite );

    QTextStream ts( &file );
    ts << doc.toString();
    file.close();

    return;
}

QList <QString> XML::getHistoryByExercise(QString name, QString date)
{
    QList <QString> readInfo;
    QString j;
    qDebug() << "XML::getHistoryByExercise" << name << " " << date;
    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/history.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return readInfo;
    }
    doc.setContent(&file);
    file.close();
    qDebug() << "XML::getHistoryByExercise 1";
    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        return readInfo;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(e.attribute("name", "") == name && date == "0")
            {
                qDebug() << "XML::getHistoryByExercise 2";
                date = e.attribute("date", "");
            }

            if(e.attribute("name", "") == name)
            {
                if( e.attribute("date", "") == date)
                {
                    qDebug() << "XML::getHistoryByExercise 3";
                    for(int i = 1; i < 10; i++)
                    {
                        j.setNum(i);
                        readInfo.append(e.attribute("variable" + j, ""));
                        readInfo.append(e.attribute("reps" + j, ""));
                        readInfo.append(e.attribute("status" + j, ""));
                    }
                }
            }
        }

      }


      n = n.nextSibling();
   }

    return readInfo;
}

QList<QString> XML::getDates()
{
    QList <QString> readInfo;

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/history.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return readInfo;
    }
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        return readInfo;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(!readInfo.isEmpty())
            {

                if(e.attribute("date", "") != readInfo.last())
                {
                    readInfo.append(e.attribute("date", ""));
                }
            }
            else
            {
                readInfo.append(e.attribute("date", ""));
            }
        }

      }


      n = n.nextSibling();
   }

    return readInfo;
}

QList < QList<QString> > XML::getHistoryByDate(QString date)
{
    QList< QList<QString> > list;
    QList <QString> readInfo;

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/history.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return list;
    }
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        return list;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(e.attribute("date", "")  == date)
            {
                readInfo.append(e.attribute("name", ""));
                readInfo.append(e.attribute("group", ""));
                list.append(readInfo);
                readInfo.clear();
            }
        }

      }


      n = n.nextSibling();
   }

    return list;
}

QList< QList<QString> > XML::readHistory()
{
    QList< QList<QString> > list;
    QList <QString> readInfo;

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/history.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return list;
    }
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        return list;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            readInfo.append(e.attribute("group", ""));
            readInfo.append(e.attribute("name", ""));
            readInfo.append(e.attribute("variable", ""));
            readInfo.append(e.attribute("date", ""));
            list.append(readInfo);
            readInfo.clear();
        }

      }


      n = n.nextSibling();
   }

    return list;
}

void XML::import(QString filename)
{
    QString name, group, muscle, info;
    QDomDocument doc( "Exercises" );
    QFile file(filename);
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );
    file.close();
    QDomElement root = doc.documentElement();


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
          if( e.tagName() == "exercise" && e.attribute( "group", "" ) == "Cardio")
          {

              name = e.attribute( "name", "" );
              saveCardio(name);
          }
        else if( e.tagName() == "exercise" )
        {

            name = e.attribute( "name", "" );
            group = e.attribute( "group", "" );
            muscle = e.attribute( "muscle", "" );
            info = e.attribute( "info", "" );
            saveEx(name,group,muscle,info);
        }
      }
      n = n.nextSibling();
   }
}

void XML::exportExercises(QModelIndexList name)
{
    QList <QString> list;
    QString group, muscle, info;
    QModelIndex tmp;

    QDomDocument doc( "Exercises" );
    QDomElement root = doc.createElement( "exercises" );
    doc.appendChild( root );

    while(!name.isEmpty())
    {
        tmp = name.takeFirst();
        list = openEx(tmp.data().toString());
        list.removeFirst();
        group = list.takeFirst();
        muscle = list.takeFirst();
        info = list.takeFirst();


        root.appendChild(createExerciseNode(doc, tmp.data().toString(), group, muscle, info));
    }
    QFile file( "/home/user/MyDocs/export.xml" );

    if(!file.open(QIODevice::WriteOnly))
        return;
    QTextStream ts( &file );
    ts << doc.toString();

   file.close();
   return;
}

void XML::saveEx(QString name, QString group, QString muscle,
                    QString info, QString newName)
{
    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/exercises.xml" );
    file.open( QIODevice::ReadWrite);
    doc.setContent( &file );

    file.close();
    qDebug () << "xml::saveEx 1";
    //leta efter en vning med samma namn, isf ta bort den
    QDomElement root = doc.documentElement();

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {
                removeElement(name, "exercises");
                qDebug () << "xml::saveEx 2";
            }
        }
      }
      n = n.nextSibling();
   }

   QTextStream ts( &file );
   ts << doc.toString();
   doc.clear();

   file.open( QIODevice::ReadWrite );
   doc.setContent( &file );
   file.remove();
   root = doc.documentElement();
   if( root.tagName() != "exercises" )
   {
       root = doc.createElement( "exercises" );
       doc.appendChild( root );
   }
   file.close();
    qDebug () << "xml::saveEx 3";
    if(newName != "0")
        root.appendChild(createExerciseNode(doc, newName, group, muscle, info));
    else
        root.appendChild(createExerciseNode(doc, name, group, muscle, info));

    if(!file.open(QIODevice::WriteOnly))
        return;

    QTextStream ts2( &file );
    ts2 << doc.toString();
    qDebug () << "xml::saveEx 4";
    file.close();
    return;
}

void XML::saveCardio(QString name)
{

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/cardio.xml" );
    file.open( QIODevice::ReadWrite );
    doc.setContent( &file );

    file.close();


    //leta efter en vning med samma namn, isf ta bort den
    QDomElement root = doc.documentElement();


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {
                removeElement(name,"cardio");
            }
        }
      }
      n = n.nextSibling();
   }
   QTextStream ts( &file );
   ts << doc.toString();

   doc.clear();
   file.open( QIODevice::ReadWrite );
   doc.setContent( &file );
   file.remove();
   root = doc.documentElement();
   if( root.tagName() != "exercises" )
   {
       root = doc.createElement( "exercises" );
       doc.appendChild( root );
   }
   file.close();

   root.appendChild(createCardioNode(doc, name));

   if(!file.open(QIODevice::WriteOnly))
       return;

   QTextStream ts2( &file );
   ts2 << doc.toString();

   file.close();
   return;
}

void XML::saveEatenFood(QString kcal, QString protein, QString carbohydrate, QString fat)
{
    QDate date = QDate::currentDate();
    QString dateString = date.toString("dd-MM-yyyy");

    QDomDocument doc( "Calories" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/calories.xml" );
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );


    QDomElement root = doc.documentElement();
    if( root.tagName() != "calorie" )
    {
        root = doc.createElement( "calorie" );
        doc.appendChild( root );
    }
    file.remove();
    file.close();

    root.appendChild(createCaloriesNode(doc, kcal, protein, carbohydrate, fat, dateString));

    if(!file.open(QIODevice::WriteOnly))
        return ;

    QTextStream ts( &file );
    ts << doc.toString();

    file.close();

    return ;
}

QList <int> XML::getTodaysCalories()
{
    QList <int> list;
    QDate date = QDate::currentDate();
    QString dateString = date.toString("dd-MM-yyyy");

    QString tmp;
    int kcal = 0, protein = 0, carbohydrate = 0, fat = 0;

    QDomDocument doc( "Calories" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/calories.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
      return list;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "calorie" )
    {
      return list;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "calorie" )
        {
            if(dateString == e.attribute( "date", "" ))
            {
                tmp = e.attribute("kcal", "");
                kcal += tmp.toInt();

                tmp = e.attribute("protein", "");
                protein += tmp.toInt();

                tmp = e.attribute("carbohydrate", "");
                carbohydrate += tmp.toInt();

                tmp = e.attribute("fat", "");
                fat += tmp.toInt();
            }
        }
      }
      n = n.nextSibling();
   }

    list.append(kcal);
    list.append(protein);
    list.append(carbohydrate);
    list.append(fat);

    return list;

}

void XML::getMeanCalories()
{

}

QList <int> XML::getCaloriesByName(QString name)
{
    QList <int> list;
    QString readInfo;

    QDomDocument doc( "Ingredients" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/ingredients.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
      return list;


    if( !doc.setContent( &file ) )
    {
      file.close();
      return list;
    }
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "ingredient" )
      return list;


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "ingredient" )
        {
            if(name == e.attribute( "name", "" ))
            {
                readInfo = e.attribute("kcal", "");
                list.append(readInfo.toInt());
                readInfo = e.attribute("protein", "");
                list.append(readInfo.toInt());
                readInfo = e.attribute("carbohydrate", "");
                list.append(readInfo.toInt());
                readInfo = e.attribute("fat", "");
                list.append(readInfo.toInt());
                return list;
            }
        }
      }
      n = n.nextSibling();
   }
    return list;
}

void XML::saveFood(QString name, QString type, QString kcal, QString protein, QString carbohydrate, QString fat)
{
    QDomDocument doc( "Ingredients" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/ingredients.xml" );
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );
    file.close();

    //leta efter en vning med samma namn, isf ta bort den
    QDomElement root = doc.documentElement();


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "ingredient" )
        {
            if(name == e.attribute( "name", "" ))
            {
                removeIngredient(name);
            }
        }
      }
      n = n.nextSibling();
   }
   QTextStream ts( &file );
   ts << doc.toString();

   doc.clear();

   file.open( QIODevice::ReadWrite );
   doc.setContent( &file );
   file.remove();

   root = doc.documentElement();
   if( root.tagName() != "ingredient" )
   {
       root = doc.createElement( "ingredient" );
       doc.appendChild( root );
   }
   file.close();

   root.appendChild(createFoodNode(doc, name, type, kcal, protein, carbohydrate, fat));

   if(!file.open(QIODevice::WriteOnly))
       return;

   ts << doc.toString();

   file.close();
   return;
}

void XML::updateLastDistance(QString name, QString distance, QString min, QString sec, QString status)
{
    QDomDocument doc( "Cardio" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/cardio.xml" );
    if( !file.open( QIODevice::ReadWrite ) )
      return;
    if( !doc.setContent( &file ) )
    {
      file.close();
      return;
    }
    file.remove();
    file.close();
    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
      return;

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {
                e.setAttribute("distance", distance);
                e.setAttribute("min", min);
                e.setAttribute("sec", sec);
                e.setAttribute("status", status);
            }
        }
      }
      n = n.nextSibling();
   }

    file.open( QIODevice::ReadWrite );

    QTextStream ts( &file );
    ts << doc.toString();
    file.close();

    return;
}


QDomElement XML::createExerciseNode( QDomDocument &d, QString name, QString group, QString muscle,
                                QString info)
{
   QDomElement cn = d.createElement( "exercise" );

   cn.setAttribute( "name", name );
   cn.setAttribute( "group", group);
   cn.setAttribute( "muscle", muscle );
   cn.setAttribute( "info", info );

   qDebug () << "xml::createExerciseNode";
   return cn;
}

QDomElement XML::createCardioNode( QDomDocument &d, QString name)
{
   QDomElement cn = d.createElement( "exercise" );

   cn.setAttribute( "name", name );
   cn.setAttribute( "group", "Cardio");
   cn.setAttribute( "distance", "0" );
   cn.setAttribute( "min", "0" );
   cn.setAttribute( "sec", "0" );
   cn.setAttribute( "status", "ok" );

   return cn;
}

QDomElement XML::createCaloriesNode( QDomDocument &d, QString kcal, QString protein, QString carbohydrate, QString fat, QString date)
{
   QDomElement cn = d.createElement( "calorie" );

   cn.setAttribute( "kcal", kcal );
   cn.setAttribute( "protein", protein );
   cn.setAttribute( "carbohydrate", carbohydrate );
   cn.setAttribute( "fat", fat );
   cn.setAttribute( "date", date );


   return cn;
}

QDomElement XML::createFoodNode( QDomDocument &d, QString name, QString type, QString kcal, QString protein, QString carbohydrate, QString fat)
{
   QDomElement cn = d.createElement( "ingredient" );

   cn.setAttribute( "name", name );
   cn.setAttribute( "type", type );
   cn.setAttribute( "kcal", kcal );
   cn.setAttribute( "protein", protein );
   cn.setAttribute( "carbohydrate", carbohydrate );
   cn.setAttribute( "fat", fat );

   return cn;
}

QDomElement XML::createHistoryNode( QDomDocument &d, QString group, QString name, QString date, QString kg, QString reps, QString status)
{

   QDomElement cn = d.createElement( "exercise" );

   cn.setAttribute("group", group);
   cn.setAttribute("name", name);
   cn.setAttribute("date", date);

   cn.setAttribute("variable1", kg);
   cn.setAttribute("variable2", "0");
   cn.setAttribute("variable3", "0");
   cn.setAttribute("variable4", "0");
   cn.setAttribute("variable5", "0");
   cn.setAttribute("variable6", "0");
   cn.setAttribute("variable7", "0");
   cn.setAttribute("variable8", "0");
   cn.setAttribute("variable9", "0");

   cn.setAttribute("reps1", reps);
   cn.setAttribute("reps2", "0");
   cn.setAttribute("reps3", "0");
   cn.setAttribute("reps4", "0");
   cn.setAttribute("reps5", "0");
   cn.setAttribute("reps6", "0");
   cn.setAttribute("reps7", "0");
   cn.setAttribute("reps8", "0");
   cn.setAttribute("reps9", "0");

   cn.setAttribute("status1", status);
   cn.setAttribute("status2", "0");
   cn.setAttribute("status3", "0");
   cn.setAttribute("status4", "0");
   cn.setAttribute("status5", "0");
   cn.setAttribute("status6", "0");
   cn.setAttribute("status7", "0");
   cn.setAttribute("status8", "0");
   cn.setAttribute("status9", "0");

   return cn;
}

QDomElement XML::createSettingsNode( QDomDocument &d, QString vibrate, QString sound, QString volume,
                                QString set, QString min, QString sec, QString calories)
{
   QDomElement cn = d.createElement( "settings" );

   cn.setAttribute( "vibrate", vibrate );
   cn.setAttribute("sound", sound);
   cn.setAttribute("volume", volume);
   cn.setAttribute( "set", set );
   cn.setAttribute( "min", min );
   cn.setAttribute( "sec", sec );
   cn.setAttribute( "calories", calories );

   return cn;
}

QList<QString> XML::openEx(QString name)
{
    QList<QString> readInfo;

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/exercises.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
      return readInfo;



    if( !doc.setContent( &file ) )
    {
      file.close();
      return readInfo;
    }
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
      return readInfo;



    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {

                readInfo.clear();
                readInfo.append(name);
                readInfo.append(e.attribute("group", ""));
                readInfo.append(e.attribute("muscle", ""));
                readInfo.append(e.attribute("info", ""));
            }
        }
      }
      n = n.nextSibling();
   }

    return readInfo;
}

QList<QString> XML::openCardio(QString name)
{
    QList<QString> readInfo;

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/cardio.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
      return readInfo;


    if( !doc.setContent( &file ) )
    {
      file.close();
      return readInfo;
    }
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
      return readInfo;


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {

                readInfo.clear();
                readInfo.append(name);
                //readInfo.append(e.attribute("group", ""));
                readInfo.append(e.attribute("distance", ""));
                readInfo.append(e.attribute("min", ""));
                readInfo.append(e.attribute("sec", ""));
                readInfo.append(e.attribute("status", ""));
            }
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

QList<QString> XML::openGroup(QString group)
{
    QList<QString> readInfo;
    readInfo.clear();

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/exercises.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
    {
        readInfo.append("file");
      return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
    {
        readInfo.append(root.tagName());
      return readInfo;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
          if(group == e.attribute( "group", ""))
          {

              readInfo.append(e.attribute("name", ""));
          }
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

QList<QString> XML::openIngredients()
{
    QList<QString> readInfo;
    readInfo.clear();

    QDomDocument doc( "Ingredients" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/ingredients.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
    {
        return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "ingredient" )
    {
        readInfo.append(root.tagName());
        return readInfo;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "ingredient" )
        {
            readInfo.append(e.attribute("name", ""));
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

QList<QString> XML::openCardio()
{
    QList<QString> readInfo;
    readInfo.clear();

    QDomDocument doc( "Cardio" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/cardio.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
    {
        readInfo.append("file");
        return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
    {
        readInfo.append(root.tagName());
      return readInfo;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
          readInfo.append(e.attribute("name", ""));

        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

QList<QString> XML::openAll()
{
    QList<QString> readInfo;
    readInfo.clear();

    QDomDocument doc( "Exercises" );
    QString str = "/home/user/.qexercise";
    QFile file( str + "/exercises.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        readInfo.append("file");
      return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
    {
        readInfo.append(root.tagName());
      return readInfo;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
          readInfo.append(e.attribute("name", ""));
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}
