#include "weightdialog.h"
#include <QDebug>
#include <QMaemo5InformationBox>

WeightDialog::WeightDialog(QWidget *parent) :
        QDialog(parent)
{
    close = false;
    qDebug () << "WeightDialog::WeightDialog 1";
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);

    //setWindowFlags(this->windowFlags() | Qt::Window);
    setWindowTitle("Save weight");

    hLayout = new QHBoxLayout();
    buttonLayout = new QVBoxLayout();
    qDebug () << "WeightDialog::WeightDialog 2";
    modelReps = new QStandardItemModel(this);
    for (int i = 1; i <= 25; i++)
        modelReps->appendRow(new QStandardItem(tr("%1").arg(i)));

    qDebug () << "WeightDialog::WeightDialog 3";
    btnReps = new QMaemo5ValueButton("Reps");
    btnReps->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorReps = new QMaemo5ListPickSelector;
    selectorReps->setModel(modelReps);
    btnReps->setPickSelector(selectorReps);

    qDebug () << "WeightDialog::WeightDialog 4";

    btnVar = new QMaemo5ValueButton();
    btnVar->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorVar = new QMaemo5ListPickSelector;

    btnVar->setPickSelector(selectorVar);

    buttonLayout->addWidget(btnReps);
    buttonLayout->addWidget(btnVar);
    hLayout->addLayout(buttonLayout);

    qDebug () << "WeightDialog::WeightDialog 5";

    radioEasy = new QRadioButton("Easy");
    radioOK = new QRadioButton("Perfect");
    radioHard = new QRadioButton("Hard");

    QVBoxLayout *vLayout = new QVBoxLayout();
    vLayout->addWidget(radioEasy);
    vLayout->addWidget(radioOK);
    vLayout->addWidget(radioHard);
    hLayout->addLayout(vLayout);

    btnSave = new QPushButton("Save");

    hLayout->addWidget(btnSave);

    setLayout(hLayout);
    xml = new XML();
    //load();
    qDebug () << "WeightDialog::WeightDialog 6";
    connect(btnSave, SIGNAL(clicked()),this,SLOT(save()));
    qDebug () << "WeightDialog::WeightDialog 7";
    resize(480,350);
}

void WeightDialog::load(QString name, QString grp, QString currentSet)
{
    QList <QString> list;
    qDebug () << "WeightDialog::load 1";
    btnVar->setText("Weight");

    exName = name;
    group = grp;
    set = currentSet;
    qDebug () << "WeightDialog::load 2";
    modelVar = new QStandardItemModel(this);
    for (int i = 1; i < 200; i++)
        modelVar->appendRow(new QStandardItem(tr("%1").arg(i)+ "kg"));

    selectorVar->setModel(modelVar);
    qDebug () << "WeightDialog::load 3";

    setWindowTitle("Save weight (set:" + currentSet + ")");

    list = xml->getHistoryByExercise(name);

    if(list.isEmpty())
        return;

    for(int i = 1; i < currentSet.toInt(); i++)
    {
        list.removeFirst();
        list.removeFirst();
        list.removeFirst();
    }

    btnVar->setValueText(list.takeFirst());
    btnReps->setValueText(list.takeFirst());




    qDebug () << "WeightDialog::load 4";
}

void WeightDialog::loadCardio(QString name, QString m, QString s)
{
    buttonLayout->removeWidget(btnReps);
    //btnReps->setEnabled(false);
    btnVar->setText("Distance");
    QList <QString> list;


    group = "Cardio";
    exName = name;
    min = m;
    sec = s;
    set = "1";

    modelVar = new QStandardItemModel(this);
    for (double i = 1; i < 500; i++)
        modelVar->appendRow(new QStandardItem(tr("%1").arg(i/10) + "km"));

    selectorVar->setModel(modelVar);
    setWindowTitle("Save distance");


    list = xml->getHistoryByExercise(name);
    if(!list.isEmpty())
        btnVar->setValueText(list.takeFirst());

}

void WeightDialog::save()
{
    qDebug () << "WeightDialog::save 1";
    QString status, weight;

    if(radioOK->isChecked())
        status = "perfect";
    else if(radioEasy->isChecked())
        status = "easy";
    else if(radioHard->isChecked())
        status = "hard";
    else
    {
        QMaemo5InformationBox::information(this, "You must select status.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    qDebug () << "WeightDialog::save 2";

    if(btnReps->valueText() == "" && group != "Cardio")
    {
        QMaemo5InformationBox::information(this, "You must select reps.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnVar->valueText() == "" && group != "Cardio")
    {
        QMaemo5InformationBox::information(this, "You must select weight.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnVar->valueText() == "" && group == "Cardio")
    {
        QMaemo5InformationBox::information(this, "You must select distance.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    qDebug () << "WeightDialog::save 3";
    weight = btnVar->valueText();

    if(group == "Cardio")
    {
        reps = min + ":" + sec;
        xml->updateLastDistance(exName, weight, min, sec, status);
        qDebug () << "WeightDialog::save 4";
    }
    else
    {
        reps = btnReps->valueText();
    }
    qDebug () << "WeightDialog::save 5";
    if(set.toInt() == 1)// || group == "Cardio")
    {
        xml->saveFirstSet(group, exName, weight, reps, status);
        qDebug () << "WeightDialog::save 6";
    }
    else
    {
        xml->updateHistory(exName,set,weight,reps,status);
        qDebug () << "WeightDialog::save 7";
    }
    close = true;
    emit next();
    qDebug () << "WeightDialog::save 8";
    this->hide();
}

void WeightDialog::closeEvent(QCloseEvent *event)
{
    if(close == false)
        return event->ignore();
}
