#include "weightwindow.h"
#include "qmaemo5rotator.h"

WeightWindow::WeightWindow(QWidget *parent) :
    QMainWindow(parent)
{
    //setAttribute(Qt::WA_Maemo5LandscapeOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QGridLayout *gridLayout = new QGridLayout();

    btnArms = new QPushButton("Arms");
    connect(btnArms,SIGNAL(clicked()),this,SLOT(showArmsList()));
    btnBack = new QPushButton("Back");
    connect(btnBack,SIGNAL(clicked()),this,SLOT(showBackList()));
    btnChest = new QPushButton("Chest");
    connect(btnChest,SIGNAL(clicked()),this,SLOT(showChestList()));
    btnLegs = new QPushButton("Legs");
    connect(btnLegs,SIGNAL(clicked()),this,SLOT(showLegsList()));
    btnShoulder = new QPushButton("Shoulder");
    connect(btnShoulder,SIGNAL(clicked()),this,SLOT(showShoulderList()));
    btnStomach = new QPushButton("Stomach");
    connect(btnStomach,SIGNAL(clicked()),this,SLOT(showStomachList()));

    gridLayout->addWidget(btnArms,1,1);
    gridLayout->addWidget(btnBack,1,2);
    gridLayout->addWidget(btnChest,2,1);
    gridLayout->addWidget(btnLegs,2,2);
    gridLayout->addWidget(btnShoulder,3,1);
    gridLayout->addWidget(btnStomach,3,2);

    widget->setLayout(gridLayout);

    createActions();
    createMenu();

    resize(480,720);
}

void WeightWindow::sendClosed()
{
    emit closed();
}

void WeightWindow::sendLandscape()
{
    emit landscape();
}

void WeightWindow::showNewIngredient()
{
    niw = new NewIngredientWindow(this);
    niw->load();
    niw->show();
}

void WeightWindow::showHistory()
{
    hw = new HistoryWindow(this);
    hw->load();
    hw->show();
}

void WeightWindow::showSettings()
{
    sw = new SettingsWindow(this);
    sw->show();
}

void WeightWindow::showNewExercise()
{
    nw = new NewExerciseWindow(this);
    emit landscape();
    connect(nw,SIGNAL(closed()),this,SLOT(sendClosed()));
    nw->load();
    nw->show();
}

void WeightWindow::showNewProgram()
{
    npw = new NewProgramWindow(this);
    npw->load();
    npw->show();
}

void WeightWindow::showArmsList()
{
    lw = new ListWindow(this);
    connect(lw,SIGNAL(closed()),this,SLOT(sendClosed()));
    connect(lw,SIGNAL(landscape()),this, SLOT(sendLandscape()));
    lw->loadExercises("Arms");
    lw->show();
}
void WeightWindow::showBackList()
{
    lw = new ListWindow(this);

    connect(lw,SIGNAL(closed()),this,SLOT(sendClosed()));
    connect(lw,SIGNAL(landscape()),this, SLOT(sendLandscape()));
    lw->loadExercises("Back");
    lw->show();
}
void WeightWindow::showChestList()
{
    lw = new ListWindow(this);
    connect(lw, SIGNAL(landscape()),this,SLOT(sendLandscape()));
    connect(lw,SIGNAL(closed()),this, SLOT(sendClosed()));
    lw->loadExercises("Chest");
    lw->show();
}
void WeightWindow::showLegsList()
{
    lw = new ListWindow(this);
    connect(lw, SIGNAL(landscape()),this,SLOT(sendLandscape()));
    connect(lw,SIGNAL(closed()),this, SLOT(sendClosed()));
    lw->loadExercises("Legs");
    lw->show();
}
void WeightWindow::showShoulderList()
{
    lw = new ListWindow(this);
    connect(lw, SIGNAL(landscape()),this,SLOT(sendLandscape()));
    connect(lw,SIGNAL(closed()),this, SLOT(sendClosed()));
    lw->loadExercises("Shoulder");
    lw->show();
}
void WeightWindow::showStomachList()
{
    lw = new ListWindow(this);
    connect(lw, SIGNAL(landscape()),this,SLOT(sendLandscape()));
    connect(lw,SIGNAL(closed()),this, SLOT(sendClosed()));
    lw->loadExercises("Stomach");
    lw->show();
}



void WeightWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
}

void WeightWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));
}
