#ifndef NEWEXERCISEWINDOW_H
#define NEWEXERCISEWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include "xml.h"


class NewExerciseWindow : public QDialog
{
    Q_OBJECT
public:
    explicit NewExerciseWindow(QWidget *parent = 0);
    void load(QString name, QString muscle, QString group, QString info);
    void load();

signals:
    void closed();
private:
    XML *xml;


    void closeEvent(QCloseEvent *event);

    QLineEdit *txtName;
    QLineEdit *txtMuscle;
    QTextEdit *txtHowTo;
    QPushButton *btnSave;
    QMaemo5ValueButton *btnGroup;
    QMaemo5ValueButton *btnPic2;
    QMaemo5ValueButton *btnPic1;
    QMaemo5ListPickSelector *selectorGroup;
    QStandardItemModel *model;

    QString pic1,pic2;
private slots:
    void saveExercise();
    void orientationChanged();
    void savePic2();
    void savePic1();


};

#endif // NEWEXERCISEWINDOW_H
