#include "startwindow.h"

StartWindow::StartWindow(QWidget *parent) :
    QMainWindow(parent)
{
    //swRot = new QMaemo5Rotator(QMaemo5Rotator::PortraitBehavior, this);
    //swRot->setCurrentOrientation(QMaemo5Rotator::PortraitOrientation);
    setAttribute(Qt::WA_Maemo5PortraitOrientation, true);//WA_Maemo5AutoOrientation
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    xml = new XML();

    QVBoxLayout *vLayout = new QVBoxLayout;
    QHBoxLayout *hLabelLayout = new QHBoxLayout;
    lblWeight = new QLabel("Weight-lift/week \n 1000kg \n 3 times/week");
    lblCardio = new QLabel("Cardio/week \n 325km \n 5 times/week");

    lblWeight->setAlignment(Qt::AlignCenter);
    lblCardio->setAlignment(Qt::AlignCenter);

    hLabelLayout->addWidget(lblWeight);
    hLabelLayout->addWidget(lblCardio);

    QHBoxLayout *hButtonLayout = new QHBoxLayout;
    btnWeight = new QPushButton(QIcon(":/res/images/weight.png"),"",this);
    connect(btnWeight,SIGNAL(clicked()),this,SLOT(showWeight()));

    btnCardio = new QPushButton(QIcon(":/res/images/cardio.png"),"",this);
    connect(btnCardio,SIGNAL(clicked()),this,SLOT(showCardio()));

    btnProgram = new QPushButton(QIcon(":/res/images/program.png"),"",this);
    connect(btnProgram,SIGNAL(clicked()),this,SLOT(showProgram()));

    btnFood = new QPushButton(QIcon(":/res/images/food.png"),"",this);
    connect(btnFood,SIGNAL(clicked()),this, SLOT(showFood()));

    hButtonLayout->addWidget(btnWeight);
    hButtonLayout->addWidget(btnCardio);
    hButtonLayout->addWidget(btnProgram);
    hButtonLayout->addWidget(btnFood);

    vLayout->addLayout(hLabelLayout);
    vLayout->addLayout(hButtonLayout);

    widget->setLayout(vLayout);

    createActions();
    createMenu();

    checkIfFirstTime();

    QList <QString> tmp = getStats();
    if(!tmp.isEmpty())
    {
        lblWeight->setText("Weight-lift \n " + tmp.takeFirst() + "kg/week \n "+ tmp.takeFirst() + "times/week");
        lblCardio->setText("Cardio \n" + tmp.takeFirst() + "km/week \n" + tmp.takeFirst() + "times/week");
    }

    resize(480,720);
}


void StartWindow::restorePortrait()
{
    setAttribute(Qt::WA_Maemo5PortraitOrientation,true);
}


QList <QString> StartWindow::getStats()
{
    QList < QList <QString> > list;
    QList <QString> tmp, stats;
    double countW = 0, countC = 0, kg = 0, km = 0;
    int weeks;

    list = xml->readHistory(); //Hmtar alla gjorda vningar
    //Grupp
    //Namn
    //Variabel
    //Dag
    while(!list.isEmpty())
    {
        tmp = list.takeFirst();

        if(tmp.takeFirst() == "Cardio")
        {
            tmp.removeFirst();
            km += tmp.takeFirst().toDouble();
            countC++;
        }
        else
        {
            tmp.removeFirst();
            kg += tmp.takeFirst().toInt();
            countW++;
        }
    }


    weeks = weeksExercise();


    kg /= weeks;
    km /= weeks;
    countW /= weeks;
    countC /= weeks;

    stats.append(QString::number(kg,'f',0));
    stats.append(QString::number(countW,'f',1));
    stats.append(QString::number(km,'f',2));
    stats.append(QString::number(countC,'f',1));



    return stats;

}


int StartWindow::weeksExercise()
{
    QList <QString> dates = xml->getDates();
    if(dates.isEmpty())
        return 1;

    QDate current, last;
    QString tmp;
    int weeks = 0;

    current = QDate::currentDate();

    tmp = dates.last();
    tmp.replace("-","");

    last = last.fromString(tmp,"ddMMyyyy");
    weeks = current.daysTo(last);
    weeks = weeks / 7 -1;
    weeks *= -1;

    return weeks;
}


StartWindow::~StartWindow()
{

}

void StartWindow::checkIfFirstTime()
{
    QFile file;
    if(!file.exists("/home/user/.qexercise/exercises.xml"))
        xml->import(":/res/xml/startExercises.xml");

    if(!file.exists("/home/user/.qexercise/cardio.xml"))
        xml->saveCardio("Cardio");

    //if(!file.exists("/home/user/.qexercise/history.xml"))
        //return true;
    //if(!file.exists("/home/user/.qexercise/program.xml"))
        //return true;

    if(!file.exists("/home/user/.qexercise/settings.xml"))
        xml->saveSettings("0","0","0","1","1","0","2500");


    if(!QDir("/home/user/.qexercise").exists())
    {
        QDir().mkpath("/home/user/.qexercise");
    }

    if(!QDir("/home/user/.qexercise/Images").exists())
    {
        QDir().mkpath("/home/user/.qexercise/Images");
    }



}
void StartWindow::changeEvent(QEvent *event)
{
    if(event->type() == QEvent::ActivationChange)
    {
        QList <QString> tmp = getStats();

        if(!tmp.isEmpty())
        {
            lblWeight->setText("Weight-lifting \n " + tmp.takeFirst() + " kg/week \n "+ tmp.takeFirst() + " times/week");
            lblCardio->setText("Cardio \n" + tmp.takeFirst() + " km/week \n" + tmp.takeFirst() + " times/week");
        }
    }
}

void StartWindow::showNewIngredient()
{
    niw = new NewIngredientWindow(this);
    niw->load();
    niw->show();
}

void StartWindow::showHistory()
{
    hw = new HistoryWindow(this);
    hw->load();
    hw->show();
}

void StartWindow::showFood()
{
    fw = new FoodWindow(this);
    connect(fw,SIGNAL(closed()),this,SLOT(restorePortrait()));
    connect(fw,SIGNAL(landscape()),this, SLOT(setLandscape()));
    fw->load();
    fw->show();

}

void StartWindow::showWeight()
{
    ww = new WeightWindow(this);
    connect(ww,SIGNAL(closed()),this,SLOT(restorePortrait()));
    connect(ww,SIGNAL(landscape()),this, SLOT(setLandscape()));
    ww->show();
}

void StartWindow::setLandscape()
{
    setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
}

void StartWindow::showCardio()
{
    lw = new ListWindow(this);
    connect(lw,SIGNAL(closed()),this,SLOT(restorePortrait()));
    connect(lw,SIGNAL(landscape()),this, SLOT(setLandscape()));
    lw->loadExercises("Cardio");
    lw->show();
}

void StartWindow::showProgram()
{
    lw = new ListWindow(this);
    connect(lw,SIGNAL(closed()),this,SLOT(restorePortrait()));
    connect(lw,SIGNAL(landscape()),this, SLOT(setLandscape()));
    lw->loadExercises("Program");
    lw->show();
}

void StartWindow::showSettings()
{
    sw = new SettingsWindow(this);
    sw->show();
}

void StartWindow::showNewExercise()
{

    nw = new NewExerciseWindow(this);
    connect(nw,SIGNAL(closed()),this,SLOT(restorePortrait()));
    nw->load();
    nw->show();

    this->setAttribute(Qt::WA_Maemo5PortraitOrientation,false);
}

void StartWindow::showNewProgram()
{
    npw = new NewProgramWindow(this);
    npw->load();
    npw->show();
}

void StartWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
}

void StartWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));
}
