#include "dietsettings.h"

DietSettings::DietSettings(QWidget *parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);
    setWindowTitle("Diet settings");
    xml = new XML();

    QVBoxLayout *vLayout = new QVBoxLayout;

    modelCalories = new QStandardItemModel(this);
    for (int i = 1; i < 100; i++)
        modelCalories->appendRow(new QStandardItem(tr("%1").arg(i*50)));

    btnCalories = new QMaemo5ValueButton("Calories");
    btnCalories->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorCalories = new QMaemo5ListPickSelector;
    selectorCalories->setModel(modelCalories);
    btnCalories->setPickSelector(selectorCalories);

    vLayout->addWidget(btnCalories);

    setLayout(vLayout);
}

void DietSettings::save()
{
    QList <QString> settings = xml->loadSettings();
    if(settings.isEmpty())
        return;

    xml->saveSettings("" + settings.takeFirst(),
                      "" + settings.takeFirst(),
                      "" + settings.takeFirst(),
                      "" + settings.takeFirst(),
                      "" + settings.takeFirst(),
                      "" + settings.takeFirst(),
                      "" + settings.takeFirst(),
                      "" + settings.takeFirst(),
                      "" + settings.takeFirst(),
                      "" + settings.takeFirst(),
                      "" + btnCalories->valueText());
}

void DietSettings::load()
{
    QList<QString> settings;

    settings = xml->loadSettings();
    if(settings.isEmpty())
        return;

    btnCalories->setValueText(settings.takeLast());

}
