#include "weightsettings.h"

WeightSettings::WeightSettings(QWidget *parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);
    setWindowTitle("Weight settings");

    QVBoxLayout *vLayout = new QVBoxLayout;

    modelSet = new QStandardItemModel(this);
    for (int i = 1; i < 25; i++)
        modelSet->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnSet = new QMaemo5ValueButton("Set");
    btnSet->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorSet = new QMaemo5ListPickSelector;
    selectorSet->setModel(modelSet);
    btnSet->setPickSelector(selectorSet);

    modelReps1 = new QStandardItemModel(this);
    for (int i = 1; i < 25; i++)
        modelReps1->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnReps1 = new QMaemo5ValueButton("Reps(Low)");
    btnReps1->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorReps1 = new QMaemo5ListPickSelector;
    selectorReps1->setModel(modelReps1);
    btnReps1->setPickSelector(selectorReps1);


    modelReps2 = new QStandardItemModel(this);
    for (int i = 1; i < 25; i++)
        modelReps2->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnReps2 = new QMaemo5ValueButton("Reps(Mid)");
    btnReps2->setValueLayout(QMaemo5ValueButton::ValueUnderText);

    selectorReps2 = new QMaemo5ListPickSelector;
    selectorReps2->setModel(modelReps2);
    btnReps2->setPickSelector(selectorReps2);


    modelReps3 = new QStandardItemModel(this);
    for (int i = 1; i < 25; i++)
        modelReps3->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnReps3 = new QMaemo5ValueButton("Reps(High)");
    btnReps3->setValueLayout(QMaemo5ValueButton::ValueUnderText);

    selectorReps3 = new QMaemo5ListPickSelector;
    selectorReps3->setModel(modelReps3);
    btnReps3->setPickSelector(selectorReps3);


    modelCurrentReps = new QStandardItemModel(this);
    modelCurrentReps->appendRow(new QStandardItem("Low"));
    modelCurrentReps->appendRow(new QStandardItem("Mid"));
    modelCurrentReps->appendRow(new QStandardItem("High"));

    btnCurrentReps = new QMaemo5ValueButton("Choose reps-mode");
    btnCurrentReps->setValueLayout(QMaemo5ValueButton::ValueUnderText);

    selectorCurrentReps = new QMaemo5ListPickSelector;
    selectorCurrentReps->setModel(modelCurrentReps);
    btnCurrentReps->setPickSelector(selectorCurrentReps);



    modelMin = new QStandardItemModel(this);
    for (int i = 0; i < 6; i++)
        modelMin->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnMin = new QMaemo5ValueButton("Minutes");
    btnMin->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorMin = new QMaemo5ListPickSelector;
    selectorMin->setModel(modelMin);
    btnMin->setPickSelector(selectorMin);

    modelSec = new QStandardItemModel(this);
    for (int i = 0; i < 12; i++)
        modelSec->appendRow(new QStandardItem(tr("%1").arg(i*5)));

    btnSec = new QMaemo5ValueButton("Seconds");
    btnSec->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorSec = new QMaemo5ListPickSelector;
    selectorSec->setModel(modelSec);
    btnSec->setPickSelector(selectorSec);


    vLayout->addWidget(btnSet);
    vLayout->addWidget(btnCurrentReps);

    QHBoxLayout *hLayout = new QHBoxLayout();
    hLayout->addWidget(btnReps1);
    hLayout->addWidget(btnReps2);
    hLayout->addWidget(btnReps3);
    vLayout->addLayout(hLayout);


    vLayout->addWidget(btnMin);
    vLayout->addWidget(btnSec);

    setLayout(vLayout);

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

void WeightSettings::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    if (screenGeometry.width() > screenGeometry.height())
    {
        btnSet->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnReps1->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnReps2->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnReps3->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnCurrentReps->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnMin->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnSec->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    }
    else
    {
        btnSet->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnReps1->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnReps2->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnReps3->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnCurrentReps->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnMin->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnSec->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    }


}

void WeightSettings::save()
{
    QList <QString> settings = xml->loadSettings();
    if(settings.isEmpty())
        return;

    xml->saveSettings("" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + btnSet->valueText(),
                 "" + btnReps1->valueText(),
                 "" + btnReps2->valueText(),
                 "" + btnReps3->valueText(),
                 "" + btnCurrentReps->valueText(),
                 "" + btnMin->valueText(),
                 "" + btnSec->valueText(),
                 "" + settings.takeLast());
}

void WeightSettings::load()
{
    QList<QString> settings;

    settings = xml->loadSettings();
    if(settings.isEmpty())
        return;

    for(int i = 0; i < 3; i++)
        settings.removeFirst();

    btnSet->setValueText(settings.takeFirst());
    btnReps1->setValueText(settings.takeFirst());
    btnReps2->setValueText(settings.takeFirst());
    btnReps3->setValueText(settings.takeFirst());
    btnCurrentReps->setValueText(settings.takeFirst());
    btnMin->setValueText(settings.takeFirst());
    btnSec->setValueText(settings.takeFirst());
}
