#include "settingswindow.h"
#include <QDebug>

SettingsWindow::SettingsWindow(QWidget *parent) : QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setWindowTitle("Settings");


    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QVBoxLayout *vLayout = new QVBoxLayout;

    btnDiet = new QPushButton("Diet");
    connect(btnDiet,SIGNAL(clicked()),this,SLOT(showDiet()));

    btnOther = new QPushButton("Other");
    connect(btnOther,SIGNAL(clicked()),this,SLOT(showOther()));

    btnWeight = new QPushButton("Weight");
    connect(btnWeight,SIGNAL(clicked()),this,SLOT(showWeight()));

    vLayout->addWidget(btnWeight);
    vLayout->addWidget(btnDiet);
    vLayout->addWidget(btnOther);



    widget->setLayout(vLayout);


}

void SettingsWindow::showDiet()
{
    ds = new DietSettings(this);
    ds->show();
}

void SettingsWindow::showOther()
{
    os = new OtherSettings(this);
    os->show();
}

void SettingsWindow::showWeight()
{
    ws = new WeightSettings(this);
    ws->show();
}
