#ifndef INFOMOTIONWINDOW_H
#define INFOMOTIONWINDOW_H

#include <QMainWindow>
#include <QtGui>

#include "newexercisewindow.h"
#include "newprogramwindow.h"
#include "settingswindow.h"
#include "xml.h"
#include "motionwindow.h"
#include "newingredientwindow.h"
#include "historywindow.h"


//class MotionWindow;

class InfoMotionWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit InfoMotionWindow(QWidget *parent = 0);
    void loadMotionExercise(QString name);

signals:
    void closed();
    void landscape();

public slots:
    void sendClosed();
    void sendLandscape();

private:
    SettingsWindow *sw;
    NewExerciseWindow *nw;
    NewProgramWindow *npw;
    HistoryWindow *hw;
    NewIngredientWindow *niw;
    MotionWindow *mw;
    XML *xml;

    void createActions();
    void createMenu();
    void changeEvent(QEvent *event);

    QAction *settingsAction;
    QAction *newExerciseAction;
    QAction *newProgramAction;
    QAction *newIngredientAction;
    QAction *historyAction;

    QLabel *lblName;
    QLabel *lblLast;

    QPushButton *btnStart;

    QString name;

private slots:
    void showSettings();
    void showNewExercise();
    void showNewProgram();
    void startExercise();
    void showNewIngredient();
    void showHistory();

};

#endif // INFOMOTIONWINDOW_H
