#ifndef SETTINGSWINDOW_H
#define SETTINGSWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include "xml.h"

class SettingsWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit SettingsWindow(QWidget *parent = 0);
    void load();
signals:

private slots:
    void orientationChanged();
private:
    XML *xml;

    void save();
    void closeEvent(QCloseEvent *event);

    QWidget *parentWidget;

    QStandardItemModel *modelSet;
    QStandardItemModel *modelReps1;
    QStandardItemModel *modelReps2;
    QStandardItemModel *modelReps3;
    QStandardItemModel *modelMin;
    QStandardItemModel *modelSec;
    QStandardItemModel *modelCurrentReps;
    QStandardItemModel *modelCalories;

    QMaemo5ValueButton *btnSet;
    QMaemo5ValueButton *btnReps1;
    QMaemo5ValueButton *btnReps2;
    QMaemo5ValueButton *btnReps3;
    QMaemo5ValueButton *btnCurrentReps;
    QMaemo5ValueButton *btnMin;
    QMaemo5ValueButton *btnSec;
    QMaemo5ValueButton *btnCalories;

    QMaemo5ListPickSelector *selectorSet;
    QMaemo5ListPickSelector *selectorReps1;
    QMaemo5ListPickSelector *selectorReps2;
    QMaemo5ListPickSelector *selectorReps3;
    QMaemo5ListPickSelector *selectorCurrentReps;
    QMaemo5ListPickSelector *selectorMin;
    QMaemo5ListPickSelector *selectorSec;
    QMaemo5ListPickSelector *selectorCalories;

    QCheckBox *chbSound;
    QCheckBox *chbVibrate;
    QSlider *sliderVolume;

};

#endif // SETTINGSWINDOW_H
