#include "foodwindow.h"
#include <QtDebug>

FoodWindow::FoodWindow(QWidget *parent) :
    QMainWindow(parent)
{

    setAttribute(Qt::WA_Maemo5StackedWindow);

    xml = new XML();
    fd = new FoodDialog(this);
    fd->hide();

    sw = new SettingsWindow(this);
    sw->hide();
    hw = new HistoryWindow(this);
    hw->hide();
    niw = new NewIngredientWindow(this);
    niw->hide();
    nw = new NewExerciseWindow(this);
    nw->hide();
    npw = new NewProgramWindow(this);
    npw->hide();

    QWidget *widget = new QWidget();

    vLayout = new QVBoxLayout();

    btnAdd = new QPushButton("Add calories");
    connect(btnAdd,SIGNAL(clicked()),this,SLOT(showDialog()));

    lblCalories = new QLabel("You have 500 kcal left today. \nYour mean kcal/day last week is 2800 kcal ");

    vLayout->addWidget(lblCalories);
    vLayout->addWidget(btnAdd);

    widget->setLayout(vLayout);
    setCentralWidget(widget);
    createActions();
    createMenu();


}

void FoodWindow::changeEvent(QEvent *event)
{
    load();
    this->update();
}

void FoodWindow::showHistory()
{
    hw->load();
    hw->show();
}


void FoodWindow::showSettings()
{
    sw->load();
    sw->show();
}

void FoodWindow::showNewExercise()
{
    nw->load();
    nw->show();
}

void FoodWindow::showNewProgram()
{
    npw->show();
}

void FoodWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
}

void FoodWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));
}

void FoodWindow::load()
{
    QList <int> list;
    QString kcal, protein, carbohydrate, fat, tmp;
    QList <QString> settings;
    int remaining;

    list = xml->getTodaysCalories();
    if(list.isEmpty())
        return;

    kcal.setNum(list.takeFirst());
    protein.setNum(list.takeFirst());
    carbohydrate.setNum(list.takeFirst());
    fat.setNum(list.takeFirst());

    settings = xml->loadSettings();
    remaining = settings.takeLast().toInt() - kcal.toInt();
    tmp.setNum(remaining);

    if(remaining >= 0)
        lblCalories->setText("You have eaten " + kcal + " kcal today (" + tmp + " left). \nYour mean kcal/day is 2800 kcal " +
                             "\nProtein: " + protein + "g. Carbohydrate: " + carbohydrate + "g. Fat: " +
                             fat + "g.");
    else
        lblCalories->setText("You have eaten to much today. \nYour mean kcal/day is 2800 kcal");


}

void FoodWindow::showDialog()
{
    fd->load();
    fd->show();
}

void FoodWindow::showNewIngredient()
{
    niw->load();
    niw->show();
}

