#ifndef XML_H
#define XML_H
#include <QString>
#include <QtXml>

class XML
{
public:
    XML();
    QList<QString> openEx(QString name);
    QList<QString> openGroup(QString group);
    //int saveNewEx( QDomDocument &d, QString name, QString group, QString muscle,
      //             QString info);
    void saveDoneEx(QString group, QString name, QString kg, QString currentReps);
    void saveSettings(QString vibrate, QString sound, QString volume
                      ,QString set, QString reps1, QString reps2, QString reps3,
                      QString currentReps, QString min, QString sec, QString calories);
    void saveEx(QString name, QString group, QString muscle,
                   QString info);
    QList <QString> loadSettings();
    QList<QString> openAll();
    void saveProgram(QString name, QList <QString> exercises);
    QList <QString> loadProgram(QString name);
    void updateLastWeight(QString name, QString weight, QString status, QString reps);

    void removeElement(QString name);

    void saveCardio(QString name);
    void updateLastDistance(QString name, QString distance, QString min, QString sec, QString status);
    QList<QString> openCardio(QString name);
    QList<QString> openCardio();

    QList< QList <QString> > readHistory();
    QList <QString> getDates();
    QList < QList<QString> > getHistoryByDate(QString date);

    void saveFood(QString name, QString type, QString kcal);
    QList<QString> openIngredients();
    void saveEatenFood(QString kcal);
    int getTodaysCalories();
    void getMeanCalories();
    int getCaloriesByName(QString name);

    void import(QString filename);
    void exportExercises(QModelIndexList name);

private:
    QDomElement createCaloriesNode ( QDomDocument &d, QString kcal, QString date);
    QDomElement createFoodNode( QDomDocument &d, QString name, QString type, QString kcal);
    QDomElement createExerciseNode( QDomDocument &d, QString name, QString group, QString muscle,
                               QString info);
    QDomElement createCardioNode( QDomDocument &d, QString name);
    QDomElement createHistoryNode(QDomDocument &d, QString group, QString name, QString date, QString kg, QString currentReps);
    QDomElement createSettingsNode( QDomDocument &d, QString vibrate, QString sound, QString volume,
                               QString set, QString reps1, QString reps2, QString reps3, QString currentReps,
                               QString min, QString sec, QString calories);
    QDomElement createProgramNode(QDomDocument &d, QString name, QList <QString> exercises);
};

#endif // XML_H
