#include "infomotionwindow.h"
#include <QtDebug>

InfoMotionWindow::InfoMotionWindow(QWidget *parent) :
        QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    sw = new SettingsWindow(this);
    sw->hide();
    niw = new NewIngredientWindow(this);
    niw->hide();
    nw = new NewExerciseWindow(this);
    nw->hide();
    npw = new NewProgramWindow(this);
    npw->hide();
    mw = new MotionWindow(this);
    mw->hide();
    hw = new HistoryWindow(this);
    hw->hide();
    xml = new XML();

    QWidget *widget = new QWidget();
    setCentralWidget(widget);

    QVBoxLayout *vLayout = new QVBoxLayout;
    lblName = new QLabel("name");
    lblLast = new QLabel("last time");
    btnStart = new QPushButton("Start");
    vLayout->addWidget(lblName);
    vLayout->addWidget(lblLast);
    vLayout->addWidget(btnStart);

    widget->setLayout(vLayout);
    createActions();
    createMenu();
}

void InfoMotionWindow::showHistory()
{
    hw->load();
    hw->show();
}

void InfoMotionWindow::showNewIngredient()
{
    niw->load();
    niw->show();
}
void InfoMotionWindow::showSettings()
{
    sw->load();
    sw->show();
}

void InfoMotionWindow::showNewExercise()
{
    nw->load();
    nw->show();
}

void InfoMotionWindow::showNewProgram()
{
    npw->show();
}

void InfoMotionWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
}

void InfoMotionWindow::changeEvent(QEvent *event)
{
    if(event->type() == QEvent::ActivationChange)
        loadMotionExercise(name);
}

void InfoMotionWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));

    connect(btnStart,SIGNAL(clicked()),this, SLOT(startExercise()));
}

void InfoMotionWindow::startExercise()
{
    mw->load(name);
    mw->show();
}

void InfoMotionWindow::loadMotionExercise(QString exercise)
{
    name = exercise;
    QList <QString> tmp;
    QString status, distance,min,sec;
    lblName->setText(name);
    tmp = xml->openCardio(name);

    //remove name
    tmp.removeFirst();

    distance = tmp.takeFirst();
    min = tmp.takeFirst();
    sec = tmp.takeFirst();
    status = tmp.takeFirst();

    lblLast->setText(distance + "km on " + min + ":" + sec + " was " + status + " last time.");
}
