#ifndef WEIGHTWINDOW_H
#define WEIGHTWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include "listwindow.h"
#include "newexercisewindow.h"
#include "newprogramwindow.h"
#include "settingswindow.h"
#include "newingredientwindow.h"
#include "historywindow.h"

//class HistoryWindow;

class WeightWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit WeightWindow(QWidget *parent = 0);

signals:

public slots:

private:
    ListWindow *lw;
    SettingsWindow *sw;
    HistoryWindow *hw;
    NewExerciseWindow *nw;
    NewProgramWindow *npw;
    NewIngredientWindow *niw;

    void createActions();
    void createMenu();

    QAction *settingsAction;
    QAction *newExerciseAction;
    QAction *newProgramAction;
    QAction *newIngredientAction;
    QAction *historyAction;

    QPushButton *btnArms;
    QPushButton *btnShoulder;
    QPushButton *btnLegs;
    QPushButton *btnStomach;
    QPushButton *btnChest;
    QPushButton *btnBack;

private slots:
    void showArmsList();
    void showBackList();
    void showChestList();
    void showLegsList();
    void showShoulderList();
    void showStomachList();
    void showHistory();

    void showSettings();
    void showNewExercise();
    void showNewProgram();
    void showNewIngredient();
};

#endif // WEIGHTWINDOW_H
