#include "settingswindow.h"
#include <QDebug>

SettingsWindow::SettingsWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setWindowTitle("Settings");
    xml = new XML();

    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QVBoxLayout *vLayout = new QVBoxLayout;

    chbSound = new QCheckBox("Sound");
    chbSound->setEnabled(false);
    vLayout->addWidget(chbSound);
    chbVibrate = new QCheckBox("Vibrate");
    vLayout->addWidget(chbVibrate);

    QLabel *label = new QLabel("Volume");
    label->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
    sliderVolume = new QSlider(Qt::Horizontal);
    sliderVolume->setEnabled(false);
    sliderVolume->setRange(0,100);
    vLayout->addWidget(label);
    vLayout->addWidget(sliderVolume);

    modelSet = new QStandardItemModel(this);
    for (int i = 1; i < 25; i++)
        modelSet->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnSet = new QMaemo5ValueButton("Set");
    btnSet->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorSet = new QMaemo5ListPickSelector;
    selectorSet->setModel(modelSet);
    btnSet->setPickSelector(selectorSet);

    modelReps1 = new QStandardItemModel(this);
    for (int i = 1; i < 25; i++)
        modelReps1->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnReps1 = new QMaemo5ValueButton("Reps(Low)");
    btnReps1->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorReps1 = new QMaemo5ListPickSelector;
    selectorReps1->setModel(modelReps1);
    btnReps1->setPickSelector(selectorReps1);


    modelReps2 = new QStandardItemModel(this);
    for (int i = 1; i < 25; i++)
        modelReps2->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnReps2 = new QMaemo5ValueButton("Reps(Mid)");
    btnReps2->setValueLayout(QMaemo5ValueButton::ValueUnderText);

    selectorReps2 = new QMaemo5ListPickSelector;
    selectorReps2->setModel(modelReps2);
    btnReps2->setPickSelector(selectorReps2);


    modelReps3 = new QStandardItemModel(this);
    for (int i = 1; i < 25; i++)
        modelReps3->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnReps3 = new QMaemo5ValueButton("Reps(High)");
    btnReps3->setValueLayout(QMaemo5ValueButton::ValueUnderText);

    selectorReps3 = new QMaemo5ListPickSelector;
    selectorReps3->setModel(modelReps3);
    btnReps3->setPickSelector(selectorReps3);


    modelCurrentReps = new QStandardItemModel(this);
    modelCurrentReps->appendRow(new QStandardItem("Low"));
    modelCurrentReps->appendRow(new QStandardItem("Mid"));
    modelCurrentReps->appendRow(new QStandardItem("High"));

    btnCurrentReps = new QMaemo5ValueButton("Choose reps-mode");
    btnCurrentReps->setValueLayout(QMaemo5ValueButton::ValueUnderText);

    selectorCurrentReps = new QMaemo5ListPickSelector;
    selectorCurrentReps->setModel(modelCurrentReps);
    btnCurrentReps->setPickSelector(selectorCurrentReps);



    modelMin = new QStandardItemModel(this);
    for (int i = 1; i < 6; i++)
        modelMin->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnMin = new QMaemo5ValueButton("Minutes");
    btnMin->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorMin = new QMaemo5ListPickSelector;
    selectorMin->setModel(modelMin);
    btnMin->setPickSelector(selectorMin);

    modelSec = new QStandardItemModel(this);
    for (int i = 0; i < 12; i++)
        modelSec->appendRow(new QStandardItem(tr("%1").arg(i*5)));

    btnSec = new QMaemo5ValueButton("Seconds");
    btnSec->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorSec = new QMaemo5ListPickSelector;
    selectorSec->setModel(modelSec);
    btnSec->setPickSelector(selectorSec);

    modelCalories = new QStandardItemModel(this);
    for (int i = 1; i < 100; i++)
        modelCalories->appendRow(new QStandardItem(tr("%1").arg(i*50)));

    btnCalories = new QMaemo5ValueButton("Calories");
    btnCalories->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorCalories = new QMaemo5ListPickSelector;
    selectorCalories->setModel(modelCalories);
    btnCalories->setPickSelector(selectorCalories);

    vLayout->addWidget(btnSet);
    vLayout->addWidget(btnCurrentReps);

    QHBoxLayout *hLayout = new QHBoxLayout();
    hLayout->addWidget(btnReps1);
    hLayout->addWidget(btnReps2);
    hLayout->addWidget(btnReps3);
    vLayout->addLayout(hLayout);
    

    vLayout->addWidget(btnMin);
    vLayout->addWidget(btnSec);

    vLayout->addWidget(btnCalories);

    widget->setLayout(vLayout);

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

void SettingsWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    if (screenGeometry.width() > screenGeometry.height())
    {
        btnSet->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnReps1->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnReps2->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnReps3->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnCurrentReps->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnMin->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        btnSec->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    }
    else
    {
        btnSet->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnReps1->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnReps2->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnReps3->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnCurrentReps->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnMin->setValueLayout(QMaemo5ValueButton::ValueUnderText);
        btnSec->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    }


}

void SettingsWindow::save()
{
    int v = sliderVolume->value();
    QString value; value.setNum(v);
    QString vibrate, sound, set, reps, min, sec;

    if(chbVibrate->isChecked())
        vibrate = "1";
    else
        vibrate = "0";

    if(chbSound->isChecked())
        sound = "1";
    else
        sound = "0";

    xml->saveSettings("" + vibrate,
                 "" + sound,
                 "" + value,
                 "" + btnSet->valueText(),
                 "" + btnReps1->valueText(),
                 "" + btnReps2->valueText(),
                 "" + btnReps3->valueText(),
                 "" + btnCurrentReps->valueText(),
                 "" + btnMin->valueText(),
                 "" + btnSec->valueText(),
                 "" + btnCalories->valueText());
}

void SettingsWindow::closeEvent(QCloseEvent *event)
{
    save();
}

void SettingsWindow::load()
{
    QList<QString> settings;
    QList<QStandardItem> list;
    QStandardItem tmpItem;
    QString vibrate, sound;

    settings = xml->loadSettings();
    if(settings.isEmpty())
        return;

    vibrate = settings.takeFirst();
    sound = settings.takeFirst();

    if(vibrate == "1")
        chbVibrate->setChecked(true);
    else
        chbVibrate->setChecked(false);

    if(sound == "1")
        chbSound->setChecked(true);
    else
        chbSound->setChecked(false);


    sliderVolume->setValue(settings.takeFirst().toInt());

    btnSet->setValueText(settings.takeFirst());
    btnReps1->setValueText(settings.takeFirst());
    btnReps2->setValueText(settings.takeFirst());
    btnReps3->setValueText(settings.takeFirst());
    btnCurrentReps->setValueText(settings.takeFirst());
    btnMin->setValueText(settings.takeFirst());
    btnSec->setValueText(settings.takeFirst());
    btnCalories->setValueText(settings.takeFirst());

}
