#ifndef FOODWINDOW_H
#define FOODWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include "fooddialog.h"
#include "newingredientwindow.h"
#include "newexercisewindow.h"
#include "newprogramwindow.h"
#include "settingswindow.h"
#include "historywindow.h"

class HistoryWindow;

class FoodWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit FoodWindow(QWidget *parent = 0);
    void load();
signals:

private:
    XML *xml;
    FoodDialog *fd;
    NewIngredientWindow *niw;
    SettingsWindow *sw;
    HistoryWindow *hw;
    NewExerciseWindow *nw;
    NewProgramWindow *npw;

    void createMenu();
    void createActions();

    QPushButton *btnAdd;
    QLabel *lblCalories;
    QVBoxLayout *vLayout;

    QAction *newIngredientAction;
    QAction *settingsAction;
    QAction *newExerciseAction;
    QAction *newProgramAction;
    QAction *historyAction;

private slots:
    void showDialog();
    void showNewIngredient();
    void showSettings();
    void showNewExercise();
    void showNewProgram();
    void showHistory();

};

#endif // FOODWINDOW_H
