#ifndef STORAGE_H
#define STORAGE_H

#include "transfer.h"
#include <QObject>

class Storage : public QObject
{
    Q_OBJECT

public:
    ~Storage();

    static Storage* instance();

    QString directory() const;
    void setDirectory(const QString &directory);

    QString errorString() const;

public slots:
    bool storeTransfers(QList<Transfer*> transfers);
    bool restoreTransfers();
    bool clearStoredTransfers();
    
private:
    explicit Storage();

    void setErrorString(const QString &errorString);

signals:
    void transfersStored();
    void transfersRestored(QList<Transfer*> transfers);
    void error();

private:
    static Storage *m_instance;

    QString m_directory;
    QString m_errorString;
};

#endif // STORAGE_H
