#ifndef SESSION_H
#define SESSION_H

#include <QObject>
#include <QQueue>
#include <QStringList>

class Settings;
class Database;
class Storage;
class UrlChecker;
class UrlRetriever;
class PluginManager;
class NetworkAccessManager;
class ClipboardMonitor;
class TransferModel;
class QThread;

class Session : public QObject
{
    Q_OBJECT

public:
    explicit Session(QObject *parent = 0);
    ~Session();
    
private:
    NetworkAccessManager *m_nam;
    Settings *m_settings;
    Database *m_database;
    Storage *m_storage;
    UrlChecker *m_urlChecker;
    UrlRetriever *m_urlRetriever;
    PluginManager *m_pluginManager;
    ClipboardMonitor *m_clipboardMonitor;
    TransferModel *m_model;
    QThread *m_thread;
};

#endif // SESSION_H
