#include "packagetransfermodel.h"

PackageTransferModel::PackageTransferModel(QObject *parent, Transfer *package) :
    QAbstractListModel(parent)
{
    m_roleNames[Transfer::NameRole] = "name";
    m_roleNames[Transfer::IconRole] = "icon";
    m_roleNames[Transfer::ServiceNameRole] = "serviceName";
    m_roleNames[Transfer::CategoryRole] = "category";
    m_roleNames[Transfer::PriorityRole] = "priority";
    m_roleNames[Transfer::PriorityStringRole] = "priorityString";
    m_roleNames[Transfer::SizeRole] = "size";
    m_roleNames[Transfer::PositionRole] = "position";
    m_roleNames[Transfer::ProgressRole] = "progress";
    m_roleNames[Transfer::StatusRole] = "status";
    m_roleNames[Transfer::StatusStringRole] = "statusString";
    m_roleNames[Transfer::ConvertibleToAudioRole] = "convertibleToAudio";
    m_roleNames[Transfer::ConvertToAudioRole] = "convertToAudio";
    m_roleNames[Transfer::PreferredConnectionsRole] = "preferredConnections";
    m_roleNames[Transfer::MaximumConnectionsRole] = "maximumConnections";
    m_roleNames[Transfer::IdRole] = "id";
    m_roleNames[Transfer::PackageIdRole] = "packageId";
    m_roleNames[Transfer::PackageNameRole] = "packageName";
    m_roleNames[Transfer::PackageStatusRole] = "packageStatus";
#if (QT_VERSION >= 0x040600) && (QT_VERSION < 0x050000)
    this->setRoleNames(m_roleNames);
#endif
    if (package) {
        this->setPackage(package);
    }
}

PackageTransferModel::~PackageTransferModel() {}

Transfer* PackageTransferModel::package() const {
    return m_list.isEmpty() ? 0 : m_list.first();
}

void PackageTransferModel::setPackage(Transfer *package) {
    if (!package) {
        return;
    }

    this->beginResetModel();

    foreach (Transfer *transfer, m_list) {
        this->disconnect(transfer, SIGNAL(dataChanged(int)), this, SLOT(onTransferDataChanged(int)));
        this->disconnect(transfer, SIGNAL(statusChanged(Transfers::Status)), this, SLOT(onTransferStatusChanged(Transfers::Status)));
    }

    m_list.clear();

    m_list.append(package);
    m_list.append(package->childTransfers());

    foreach (Transfer *transfer, m_list) {
        this->connect(transfer, SIGNAL(dataChanged(int)), this, SLOT(onTransferDataChanged(int)));
        this->connect(transfer, SIGNAL(statusChanged(Transfers::Status)), this, SLOT(onTransferStatusChanged(Transfers::Status)));
    }

    this->endResetModel();

    emit countChanged(this->rowCount());
}

#if (QT_VERSION >= 0x050000) || (QT_VERSION < 0x040600)
QHash<int, QByteArray> TransferModel::roleNames() const {
    return m_roleNames;
}
#endif

Qt::ItemFlags PackageTransferModel::flags(const QModelIndex &index) const {
    Q_UNUSED(index)

    return Qt::ItemIsEnabled;
}

int PackageTransferModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant PackageTransferModel::data(const QModelIndex &index, int role) const {
    if (index.isValid()) {
        if (Transfer *transfer = this->get(index)) {
            return transfer->data(role);
        }
    }

    return QVariant();
}

QVariant PackageTransferModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QVariant PackageTransferModel::data(const QString &id, const QByteArray &role) const {
    if (Transfer *transfer = this->get(id)) {
        return transfer->data(this->roleNames().key(role));
    }

    return QVariant();
}

QMap<int, QVariant> PackageTransferModel::itemData(const QModelIndex &index) const {
    if (index.isValid()) {
        if (Transfer *transfer = this->get(index)) {
            return transfer->itemData();
        }
    }

    return QMap<int, QVariant>();
}

QVariantMap PackageTransferModel::itemData(int row) const {
    if (Transfer *transfer = this->get(row)) {
        return transfer->itemDataWithRoleNames();
    }

    return QVariantMap();
}

QVariantMap PackageTransferModel::itemData(const QString &id) const {
    foreach (Transfer *transfer, m_list) {
        if (transfer->id() == id) {
            return transfer->itemDataWithRoleNames();
        }
    }

    return QVariantMap();
}

QVariantList PackageTransferModel::allItemData() const {
    QVariantList list;

    foreach (Transfer *transfer, m_list) {
        list.append(transfer->itemDataWithRoleNames());
    }

    return list;
}

bool PackageTransferModel::setData(const QModelIndex &index, const QVariant &value, int role) {
    if (index.isValid()) {
        if (Transfer *transfer = this->get(index)) {
            return transfer->setData(role, value);
        }
    }

    return false;
}

bool PackageTransferModel::setData(int row, const QVariant &value, const QByteArray &role) {
    return this->setData(this->index(row), value, this->roleNames().key(role));
}

bool PackageTransferModel::setData(const QString &id, const QVariant &value, const QByteArray &role) {
    if (Transfer *transfer = this->get(id)) {
        return transfer->setData(this->roleNames().key(role), value);
    }

    return false;
}

Transfer* PackageTransferModel::get(const QModelIndex &index) const {
    if ((index.row() >= 0) && (index.row() < this->rowCount())) {
        return m_list.at(index.row());
    }

    return 0;
}

Transfer* PackageTransferModel::get(int row) const {
    return this->get(this->index(row));
}

Transfer* PackageTransferModel::get(const QString &id) const {
    foreach (Transfer *transfer, m_list) {
        if (transfer->id() == id) {
            return transfer;
        }
    }

    return 0;
}

void PackageTransferModel::onTransferDataChanged(int role) {
    Q_UNUSED(role)

    if (Transfer *transfer = qobject_cast<Transfer*>(this->sender())) {
        int i = m_list.indexOf(transfer);

        if (i >= 0) {
            QModelIndex index = this->index(transfer->rowNumber());
            emit dataChanged(index, index);
        }
    }
}

void PackageTransferModel::onTransferStatusChanged(Transfers::Status status) {
    switch (status) {
    case Transfers::Completed:
    case Transfers::Cancelled:
        if (Transfer *transfer = qobject_cast<Transfer*>(this->sender())) {
            this->beginResetModel();
            m_list.removeOne(transfer);
            this->endResetModel();
            emit countChanged(this->rowCount());
        }

        return;
    default:
        return;
    }
}
