#include "cookiejar.h"
#include <QRegExp>

CookieJar::CookieJar(QObject *parent) :
    QNetworkCookieJar(parent)
{
}

QList<QNetworkCookie> CookieJar::cookiesForUrl(const QUrl &url) const {
    QList<QNetworkCookie> cookies = QNetworkCookieJar::cookiesForUrl(url);

    if (url.toString().contains(QRegExp("(dailymotion.com/video|dailymotion.com/cdn|dai.ly)"))) {
        cookies << QNetworkCookie("family_filter", "false");
    }

    return cookies;
}
