#ifndef ARCHIVEEXTRACTOR_H
#define ARCHIVEEXTRACTOR_H

#include <QObject>
#include <QProcess>

class ArchiveExtractor : public QObject
{
    Q_OBJECT

public:
    explicit ArchiveExtractor(QObject *parent = 0);
    ~ArchiveExtractor();

    QString fileName() const;
    void setFileName(const QString &fileName);

    QString outputDirectory() const;
    void setOutputDirectory(const QString &directory);

    QString password() const;
    void setPassword(const QString &password);

    bool createSubfolder() const;
    void setCreateSubfolder(bool subfolder);

    QString errorString() const;

public slots:
    void start();
    void start(const QString &fileName, const QString &outputDirectory, const QString &password = QString(), bool createSubfolder = true);

private:
    void setErrorString(const QString &errorString);

private slots:
    void onProcessFinished(int exitCode, QProcess::ExitStatus status);

signals:
    void finished();
    void error();
    
private:
    QProcess *m_process;
    QString m_fileName;
    QString m_outputDirectory;
    QString m_password;
    QString m_errorString;
    bool m_createSubfolder;
};

#endif // ARCHIVEEXTRACTOR_H
