import QtQuick 1.1
import com.nokia.symbian 1.1

Window {
    id: appWindow

    property alias toolBar: toolBar
    property alias pageStack: pageStack

    PageStack {
        id: pageStack

        anchors {
            left: parent.left
            right: parent.right
            top: statusBar.bottom
            bottom: parent.bottom
            bottomMargin: toolBar.height
        }

        Component.onCompleted: push(mainPage, undefined, true)
    }

    StatusBar {
        id: statusBar

        anchors {
            left: parent.left
            right: parent.right
            top: parent.top
        }
    }

    ToolBar {
        id: toolBar

        anchors {
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }

        tools: pageStack.currentPage === null ? null : pageStack.currentPage.tools

        states: State {
            name: "hidden"
            AnchorChanges { target: toolBar; anchors { bottom: undefined; top: parent.bottom } }
        }

        transitions: Transition {
            from: "hidden"
            to: ""
            AnchorAnimation { easing.type: Easing.OutQuad; duration: 200 }
        }
    }

    MainPage {
        id: mainPage
    }
}
