import QtQuick 1.1
import com.nokia.symbian 1.1

Item {
    id: root

    function close() {
        root.visible = false;
        progressBar.value = 0;
        progressBar.maximumValue = 0;
        urlModel.clear();
    }

    function addUrls(urls) {
        progressBar.maximumValue += urls.length;
        root.visible = true;

        for (var i = 0; i < urls.length; i++) {
            urlModel.append({ "url": urls[i].toString(), "checked": false, "ok": false });
        }
    }

    function onUrlChecked(ok, url, service, fileName, done) {
        if (done) {
            urlModel.set(progressBar.value, { "checked": true, "ok": ok });
            progressBar.value++;
        }
    }

    Connections {
        target: UrlChecker
        onUrlsQueued: root.addUrls(urls)
        onUrlChecked: root.onUrlChecked(ok, url, service, fileName, done)
    }

    ListView {
        id: view

        anchors {
            top: parent.top
            left: parent.left
            right: parent.right
            bottom: column.top
            margins: 10
        }

        model: ListModel {
            id: urlModel
        }

        header: Item {
            width: view.width
            height: 48

            Label {
                id: urlLabel

                anchors {
                    left: parent.left
                    leftMargin: 5
                    verticalCenter: parent.verticalCenter
                }

                verticalAlignment: Text.AlignVCenter
                text: qsTr("URL")
            }

            Label {
                id: okLabel

                anchors {
                    right: parent.right
                    rightMargin: 5
                    verticalCenter: parent.verticalCenter
                }

                verticalAlignment: Text.AlignVCenter
                text: qsTr("OK") + "?"
            }

            Rectangle {
                height: 1
                anchors {
                    left: parent.left
                    leftMargin: 5
                    right: parent.right
                    rightMargin: 5
                    bottom: parent.bottom
                }

                color: "#4d4d4d"
                opacity: 0.5
            }

            Rectangle {
                width: 1
                anchors {
                    top: parent.top
                    right: okLabel.left
                    bottom: parent.bottom
                    margins: 5
                }

                color: "#4d4d4d"
                opacity: 0.5
            }
        }

        delegate: UrlCheckDelegate {}
    }

    ScrollDecorator {
        flickableItem: view
    }

    Column {
        id: column

        spacing: 10
        anchors {
            left: parent.left
            right: parent.right
            bottom: parent.bottom
            margins: 10
        }

        ProgressBar {
            id: progressBar

            width: parent.width
            value: 0
            maximumValue: 0
        }

        Label {
            font.pixelSize: 18
            font.italic: true
            text: UrlChecker.urlChecksCancelled ? qsTr("Cancelled") : progressBar.value < progressBar.maximumValue ? qsTr("Checking URLs") : qsTr("Complete")
        }

        Button {
            x: Math.floor((parent.width / 2) - (width / 2))
            width: 200
            text: (UrlChecker.urlChecksCancelled) || (progressBar.value == progressBar.maximumValue) ? qsTr("Close") : qsTr("Cancel")
            onClicked: (UrlChecker.urlChecksCancelled) || (progressBar.value == progressBar.maximumValue) ? root.close() : UrlChecker.urlChecksCancelled = true
        }
    }
}
