import QtQuick 1.1
import com.nokia.symbian 1.1
import com.marxian.models 1.0
import com.marxian.items 1.0
import com.marxian.enums 1.0
import "scripts/createobject.js" as ObjectCreator

MySheet {
    id: root

    property TransferItem transfer: null

    function showCategoryDialog() {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("CategorySelectionDialog.qml"), pageStack);
        dialog.setValue(transfer.category);
        dialog.open();
        dialog.valueChosen.connect(transfer.setCategory);
    }

    function showPriorityDialog() {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("PrioritySelectionDialog.qml"), pageStack);
        dialog.setValue(transfer.priority);
        dialog.open();
        dialog.valueChosen.connect(transfer.setPriority);
    }

    acceptButtonText: qsTr("Done")
    content: Item {
        id: contentItem

        anchors.fill: parent
        clip: true

        Flickable {
            id: flicker

            anchors {
                fill: parent
                topMargin: 10
                leftMargin: 10
                rightMargin: 10
            }

            contentHeight: column.height

            Column {
                id: column

                spacing: 10
                anchors {
                    top: parent.top
                    left: parent.left
                    right: parent.right
                }

                SeparatorLabel {
                    width: parent.width
                    text: qsTr("Details")
                }

                Row {
                    spacing: 10

                    ServiceIcon {
                        id: serviceIcon

                        width: 48
                        height: 48
                        iconSource: transfer === null ? "" : iconPath + transfer.iconName
                        smooth: true
                    }

                    TextField {
                        id: fileNameInput

                        width: column.width - serviceIcon.width - fileNameButton.width - 20
                        text: transfer === null ? "" : transfer.fileName
                        inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase

                        Keys.onEnterPressed: {
                            fileNameInput.closeSoftwareInputPanel();
                            transfer.fileName = fileNameInput.text;
                        }
                        Keys.onReturnPressed: {
                            fileNameInput.closeSoftwareInputPanel();
                            transfer.fileName = fileNameInput.text;
                        }
                    }

                    Button {
                        id: fileNameButton

                        width: height
                        iconSource: "qrc:/done.png"
                        enabled: (fileNameInput.text != "") && (transfer !== null) && (fileNameInput.text !== transfer.fileName)
                        onClicked: transfer.fileName = fileNameInput.text
                    }
                }

                Row {
                    Label {
                        text: qsTr("Status") + ": "
                    }

                    Label {
                        text: transfer === null ? "" : transfer.statusText
                        color: transfer === null ? "white" : transfer.status === Transfers.Downloading ? "green" : transfer.status === Transfers.Failed ? "red" : "white"
                    }
                }

                Label {
                    width: parent.width
                    visible: (transfer !== null) && ((transfer.status === Transfers.Failed) || (transfer.status === Transfers.ShortWait) || (transfer.status === Transfers.LongWait))
                    text: transfer === null ? "" : transfer.statusInfo
                    color: (transfer !== null) && (transfer.status === Transfers.Failed) ? "red" : "green"
                    elide: Text.ElideRight
                }

                ProgressBar {
                    id: progressBar

                    width: parent.width
                    minimumValue: 0
                    maximumValue: 100
                    value: transfer === null ? 0 : transfer.progress
                    indeterminate: (transfer === null) || (transfer.status === Transfers.Connecting)
                }

                Label {
                    id: speedLabel

                    color: "#4d4d4d"
                    text: (transfer === null) || (transfer.status !== Transfers.Downloading) ? "" : Math.floor(transfer.speed / 1024) + "kB/s"
                }

                SelectionListItem {
                    id: categorySelector

                    x: -10
                    width: parent.width + 20
                    title: qsTr("Category")
                    subTitle: transfer === null ? "" : transfer.category
                    onClicked: root.showCategoryDialog()
                }

                SelectionListItem {
                    id: prioritySelector

                    x: -10
                    width: parent.width + 20
                    title: qsTr("Priority")
                    subTitle: transfer === null ? "" : transfer.priorityText
                    onClicked: root.showPriorityDialog()
                }

                SeparatorLabel {
                    width: parent.width
                    text: qsTr("Actions")
                }

                Button {
                    id: pauseResumeButton

                    x: Math.floor((parent.width / 2) - (width / 2))
                    width: 200
                    text: (transfer === null) || (transfer.status === Transfers.Paused) || (transfer.status === Transfers.Failed) ? qsTr("Resume") : qsTr("Pause")
                    onClicked: (transfer === null) || (transfer.status === Transfers.Paused) || (transfer.status === Transfers.Failed) ? transfer.status = Transfers.Queued : transfer.status = Transfers.Paused
                }

                Button {
                    id: cancelButton

                    x: Math.floor((parent.width / 2) - (width / 2))
                    width: 200
                    text: qsTr("Cancel")
                    onClicked: {
                        transfer.status = Transfers.Cancelled;
                        root.accept();
                    }
                }
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }
}
