import QtQuick 1.1
import com.nokia.symbian 1.1
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolButton {
            iconSource: "toolbar-back"
            onClicked: pageStack.pop()
        }
    }

    Flickable {
        id: flicker

        anchors.fill: parent
        contentHeight: column.height

        Column {
            id: column

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }

            TitleHeader {
                title: qsTr("Other")
            }

            SelectionListItem {
                id: concurrentSelector

                title: qsTr("Screen orientation")
                subTitle: Settings.screenOrientationString
                onClicked: {
                    var dialog = ObjectCreator.createObject(Qt.resolvedUrl("OrientationSelectionDialog.qml"), pageStack);
                    dialog.open();
                }
            }

            SwitchItem {
                id: clipboardSwitch

                title: qsTr("Monitor clipboard for URLs")
                checked: Settings.monitorClipboard
                onCheckedChanged: Settings.monitorClipboard = checked
            }
        }
    }

    ScrollDecorator {
        flickableItem: flicker
    }
}
