import QtQuick 1.1
import com.nokia.symbian 1.1

Item {
    id: root

    property string __key
    property alias title: titleLabel.text

    function setKey(key, defaultValue) {
        root.__key = key;
        var value = Settings.setting(key);

        if (value === undefined) {
            value = defaultValue;
        }

        textField.text = value;
    }

    height: 80
    width: !parent ? implicitWidth : parent.width

    Label {
        id: titleLabel

        anchors {
            left: parent.left
            leftMargin: 10
            right: parent.right
            rightMargin: 10
            top: parent.top
        }

        elide: Text.ElideRight
    }

    TextField {
        id: textField

        anchors {
            left: parent.left
            leftMargin: 30
            right: parent.right
            rightMargin: 30
            top: titleLabel.bottom
            topMargin: 10
        }

        inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase

        Keys.onEnterPressed: textField.platformCloseSoftwareInputPanel()
        Keys.onReturnPressed: textField.platformCloseSoftwareInputPanel()

        onTextChanged: Settings.setSetting(root.__key, textField.text)
    }
}
