import QtQuick 1.1
import com.nokia.symbian 1.1

MySheet {
    id: root

    property alias serviceName: serviceLabel.text
    property alias serviceIcon: serviceIcon.iconSource
    property alias username: usernameField.text
    property alias password: passwordField.text
    property bool isDecaptchaAccount: false

    signal accountSet(string serviceName, string username, string password)

    rejectButtonText: qsTr("Cancel")
    acceptButtonText: (usernameField.text == "") || (passwordField.text == "") ? "" : qsTr("Done")
    content: Item {
        id: contentItem

        anchors.fill: parent
        clip: true

        Flickable {
            id: flicker

            anchors {
                fill: parent
                topMargin: 10
                leftMargin: 10
                rightMargin: 10
            }

            contentHeight: column.height

            Column {
                id: column

                anchors {
                    top: parent.top
                    left: parent.left
                    right: parent.right
                }

                spacing: 10

                Row {
                    width: parent.width
                    spacing: 10

                    ServiceIcon {
                        id: serviceIcon

                        width: 64
                        height: 64
                    }

                    Label {
                        id: serviceLabel

                        width: parent.width - serviceIcon.width - 10
                        elide: Text.ElideRight
                        font.bold: true
                    }
                }

                Label {
                    text: qsTr("Username") + "/" + qsTr("email")
                }

                TextField {
                    id: usernameField

                    width: parent.width
                    inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
                    Keys.onEnterPressed: passwordField.focus = true
                    Keys.onReturnPressed: passwordField.focus = true
                }

                Label {
                    text: qsTr("Password")
                }

                TextField {
                    id: passwordField

                    width: parent.width
                    echoMode: TextInput.Password
                    inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
                    Keys.onEnterPressed: root.accept()
                    Keys.onReturnPressed: root.accept()
                }

                CheckBox {
                    id: checkbox

                    text: qsTr("Use this decaptcha service")
                    visible: root.isDecaptchaAccount
                    enabled: (root.username != "") && (root.password != "")
                    checked: Settings.decaptchaService == root.serviceName
                    onClicked: Settings.decaptchaService = checkbox.checked ? root.serviceName : ""
                }
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }

    onAccepted: root.accountSet(root.serviceName, root.username, root.password)
}
