import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    property alias title: title.text
    property alias subTitle: subTitle.text

    signal clicked

    width: parent.width
    height: 80
    opacity: enabled ? 1 : 0.3

    Rectangle {
        anchors.fill: parent
        color: "#4d4d4d"
        opacity: 0.5
        visible: mouseArea.pressed
    }

    Column {
        id: column

        anchors {
            left: parent.left
            leftMargin: 10
            right: icon.left
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        Label {
            id: title

            width: parent.width
            font.bold: true
            verticalAlignment: Text.AlignVCenter
            elide: Text.ElideRight
        }

        Label {
            id: subTitle

            width: parent.width
            color: "#4d4d4d"
            verticalAlignment: Text.AlignVCenter
            elide: Text.ElideRight
        }
    }

    Image {
        id: icon

        anchors {
            right: parent.right
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        source: "image://theme/icon-m-textinput-combobox-arrow"
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
    }
}
