import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    signal clicked

    width: parent.width
    height: 80

    Rectangle {
        id: highlight

        anchors {
            fill: parent
            topMargin: 1
            bottomMargin: 1
        }

        color: "#4d4d4d"
        opacity: 0.5
        visible: mouseArea.pressed
    }

    Image {
        id: icon

        anchors {
            left: parent.left
            leftMargin: 10
            verticalCenter: parent.verticalCenter
        }

        source: parent.ListView.view.model.isFolder(index) ? "image://theme/icon-m-toolbar-directory-white" : "image://theme/icon-m-toolbar-attachment-white"
    }

    Label {
        anchors {
            left: icon.right
            leftMargin: 10
            right: parent.right
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        font.bold: true
        elide: Text.ElideRight
        text: fileName
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: root.clicked()
    }
}
