import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxian.models 1.0
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    function showEditCategoryDialog(name, path) {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("EditCategoryDialog.qml"), appWindow.pageStack);

        if ((name) && (path)) {
            dialog.name = name;
            dialog.path = path;
        }

        dialog.categorySet.connect(categoriesModel.addCategory);
        dialog.open();
    }

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolIcon {
            platformIconId: "toolbar-back"
            onClicked: appWindow.pageStack.pop()
        }

        ToolIcon {
            platformIconId: "toolbar-add"
            onClicked: root.showEditCategoryDialog()
        }
    }

    ContextMenu {
        id: contextMenu

        MenuLayout {

            MenuItem {
                text: qsTr("Edit")
                onClicked: root.showEditCategoryDialog(categoriesModel.name(view.selectedIndex), categoriesModel.path(view.selectedIndex))
            }

            MenuItem {
                text: qsTr("Remove")
                onClicked: categoriesModel.removeCategory(view.selectedIndex)
            }
        }
    }

    ListView {
        id: view

        property int selectedIndex: -1

        anchors.fill: parent
        model: CategoriesModel {
            id: categoriesModel

            session: Session
        }
        header: TitleHeader {
            title: qsTr("Categories")
        }
        delegate: CategoryDelegate {
            onClicked: root.showEditCategoryDialog(name, path)
            onPressAndHold: {
                view.selectedIndex = index;
                contextMenu.open();
            }
        }
    }
}

