import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    signal clicked
    signal pressAndHold

    width: parent.width
    height: 80

    Rectangle {
        anchors.fill: parent
        color: "#4d4d4d"
        opacity: 0.5
        visible: mouseArea.pressed
    }

    ServiceIcon {
        id: icon

        smooth: true
        anchors {
            left: parent.left
            leftMargin: 10
            verticalCenter: parent.verticalCenter
        }

        iconSource: iconPath + serviceIcon
    }

    Label {
        anchors {
            top: icon.top
            left: icon.right
            leftMargin: 10
            right: parent.right
            rightMargin: 10
        }

        font.bold: true
        wrapMode: Text.NoWrap
        elide: Text.ElideRight
        text: serviceName
    }

    Label {
        anchors {
            bottom: parent.bottom
            left: icon.right
            leftMargin: 10
            right: parent.right
            rightMargin: 10
        }

        color: "#4d4d4d"
        wrapMode: Text.NoWrap
        elide: Text.ElideRight
        text: username === "" ? qsTr("No account") : username
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: root.clicked()
        onPressAndHold: root.pressAndHold()
    }
}
