#ifndef VIMEO_H
#define VIMEO_H

#include <QObject>
#include <QStringList>
#include <QUrl>
#include "serviceplugin.h"

class Vimeo : public ServicePlugin
{
    Q_OBJECT
    Q_INTERFACES(ServiceInterface)

public:
    explicit Vimeo(QObject *parent = 0);
    ServicePlugin* createServicePlugin() { return new Vimeo; }
    inline QString iconName() const { return QString("vimeo.jpg"); }
    inline QString serviceName() const { return QString("Vimeo"); }
    QRegExp urlPattern() const;
    bool urlSupported(const QUrl &url) const;
    void checkUrl(const QUrl &url);
    void getDownloadUrl(const QUrl &url);
    inline bool loginSupported() const { return false; }
    inline bool recaptchaRequired() const { return false; }

private slots:
    void checkUrlIsValid();
    void parseVideoPage();
    void getRedirect(const QUrl &url);
    void checkRedirect();

private:
    QStringList m_formatList;
};

#endif // VIMEO_H
