#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QLineEdit>

#define BC "/usr/bin/bc -l"
#define BC_WAIT 1000

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->combo->setFocus();
    keyListener = new KeyListener(this);
    ui->combo->installEventFilter(keyListener);
    connect(keyListener, SIGNAL(enterKeyPressed()), this, SLOT(on_pbEnter_clicked()));
    connect(&bc, SIGNAL(readyReadStandardOutput()), this, SLOT(displayOutput()));
    connect(&bc, SIGNAL(readyReadStandardError()), this, SLOT(displayOutput()));
    bc.start(BC);
}

MainWindow::~MainWindow()
{
    bc.write("quit\n");
    bc.waitForFinished(BC_WAIT);
    delete ui;
    delete keyListener;
}

void MainWindow::appendChar(QChar c)
{
//    if (ui->combo->lineEdit()->hasSelectedText())
//    {
//        ui->combo->lineEdit()->del();
//    }
//    ui->combo->lineEdit()->setText(ui->combo->lineEdit()->text() + c);
    ui->combo->lineEdit()->insert(c);
    ui->combo->setFocus();

//    ui->combo->setItemText(0, ui->combo->lineEdit()->text());
}

void MainWindow::displayOutput()
{
    QString output = bc.readAllStandardOutput();
    QString error = bc.readAllStandardError();
    output.remove("\n");
    error.remove("\n");
    if (!output.isEmpty()) ui->text->append("<b>"+output+"</b>");
    if (!error.isEmpty()) ui->text->append("<u>"+error+"</u>");
}

void MainWindow::on_pbEnter_clicked()
{
    QString input = ui->combo->lineEdit()->text().toLatin1();
    bc.write(input.toLatin1());
    bc.write("\n");
    ui->text->append("<i>> " + input + "</i>");
    ui->combo->insertItem(0, ui->combo->lineEdit()->text());
    ui->combo->lineEdit()->setText("");
    ui->combo->setCurrentIndex(-1);
    ui->combo->setFocus();
}

void MainWindow::on_pb0_clicked()
{
    appendChar('0');
}

void MainWindow::on_pb1_clicked()
{
    appendChar('1');
}

void MainWindow::on_pb2_clicked()
{
    appendChar('2');
}

void MainWindow::on_pb3_clicked()
{
    appendChar('3');
}

void MainWindow::on_pb4_clicked()
{
    appendChar('4');
}

void MainWindow::on_pb5_clicked()
{
    appendChar('5');
}

void MainWindow::on_pb6_clicked()
{
    appendChar('6');
}

void MainWindow::on_pb7_clicked()
{
    appendChar('7');
}

void MainWindow::on_pb8_clicked()
{
    appendChar('8');
}

void MainWindow::on_pb9_clicked()
{
    appendChar('9');
}

void MainWindow::on_pbDot_clicked()
{
    appendChar('.');
}

void MainWindow::on_pbBracketOpen_clicked()
{
    appendChar('(');
}

void MainWindow::on_pbBracketClose_clicked()
{
    appendChar(')');
}

void MainWindow::on_pbPlus_clicked()
{
    appendChar('+');
}

void MainWindow::on_pbMinus_clicked()
{
    appendChar('-');
}

void MainWindow::on_pbMultiply_clicked()
{
    appendChar('*');
}

void MainWindow::on_pbDivide_clicked()
{
    appendChar('/');
}

void MainWindow::on_pbFn_clicked()
{
}

void MainWindow::on_pbDelete_clicked()
{
    QString s = ui->combo->lineEdit()->text();
    s.chop(1);
    ui->combo->lineEdit()->setText(s);
    ui->combo->setFocus();
}

void MainWindow::on_pbVariable_clicked()
{
}
