#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QtDeclarative>
#include "qplatformdefs.h"
#include "qmlapplicationviewer.h"
#include "ui/calcserver.h"

Q_DECL_EXPORT int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QmlApplicationViewer viewer;

    //QObject::connect(&app, SIGNAL(aboutToQuit()), &settings, SLOT(saveSettings()));

    QalcUI::CalcServer calcServer;

    QDeclarativeContext *context = viewer.rootContext();
    context->setContextProperty("CalcServer", &calcServer);
    //context->setContextProperty("Settings", &settings);
    //settings.restoreSettings();

    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);

#if defined(MEEGO_EDITION_HARMATTAN)
    viewer.setMainQmlFile(QLatin1String("qml/qalculette/mainN9.qml"));
    viewer.showFullScreen();
#else
    viewer.setMainQmlFile(QLatin1String("qml/qalculette/main.qml"));
    viewer.show();
#endif

    return app.exec();
}
