#include "operandfactory.h"
#include <vector>
#include <QRegExp>
#include <QStringList>

#include "factories/operatorsfactory.h"
#include "operands/addition.h"
#include "operands/multiplication.h"
#include "operands/number.h"
#include "operands/function.h"

using namespace QalcuLib;
using namespace std;

OperandPtr QalcuLib::mainFactory(const QString &expression, OperandDictionaryPtr dic)
{
    strAdditionPtr resCreator(new strAddition(expression));
    return resCreator->makeOperand(dic);
}

OperandPtr QalcuLib::endFactory(const QString &expression, OperandDictionaryPtr dic)
{
    OperandPtr returnVal;
    QRegExp functionCheck("^([+-]?)([a-z]*)\\((.+)\\)$",Qt::CaseInsensitive);
    if (functionCheck.exactMatch(expression))
    {
        //there are parenthesis
        QStringList tempList = functionCheck.capturedTexts();
        OperandPtr innerPtr;
        OperandPtr innerInnerPtr = mainFactory(tempList.at(3), dic);
        if ( !(tempList.at(2).isEmpty()) )
        {
            innerPtr = OperandPtr( new Function(innerInnerPtr, tempList.at(2)) );
        }
        else
        {
            innerPtr = innerInnerPtr;
        }

        if ( tempList.at(1) == "-" )
        {
            vector<OperandPtr> multiples;
            multiples.push_back( OperandPtr(new Number(-1.0)) );
            multiples.push_back(innerPtr);
            vector<bool> isMultiple;
            isMultiple.push_back(true);
            isMultiple.push_back(true);
            returnVal = OperandPtr( new Multiplication( multiples, isMultiple) );
        }
        else
        {
            returnVal = innerPtr;
        }
    }
    else
    {
        bool ok;
        double val = expression.toDouble(&ok);
        if (!ok)
            returnVal = dic->getOperand(expression);
        else
            returnVal = OperandPtr(new Number(val));
    }
    return returnVal;
}
