# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

from config import Config

from ui_taskeditor import Ui_TaskEditor
from ui_channels import Ui_Channels
from ui_synchronize import Ui_Synchronize
from ui_messageeditor import Ui_MessageEditor


class Ui_MainMenuBar(QtGui.QMenuBar):
    def __init__(self):
        QtGui.QMenuBar.__init__(self)
                
        self.taskListAction = QtGui.QAction(self)
        self.taskListAction.setText(self.tr("Tasks"))
        self.taskListAction.setCheckable(True)
        self.channelAction = QtGui.QAction(self)
        if Config.mode_workstreamer:
            self.channelAction.setText(self.tr("Project"))
        else:
            self.channelAction.setText(self.tr("Channel"))
        self.channelAction.setCheckable(True)
        self.streamAction = QtGui.QAction(self)
        self.streamAction.setText(self.tr("Stream"))
        self.streamAction.setCheckable(True)

        self.logoutAction = QtGui.QAction(self)
        self.logoutAction.setText(self.tr("Log out"))

        self.channelsAction = QtGui.QAction(self)
        if Config.mode_workstreamer:
            self.channelsAction.setText(self.tr("Projects"))
        else:
            self.channelsAction.setText(self.tr("Channels"))
        self.newMessageAction = QtGui.QAction(self)
        self.newMessageAction.setText(self.tr("New message"))
        self.newTaskAction = QtGui.QAction(self)
        self.newTaskAction.setText(self.tr("New Task"))
        self.synchronizeAction = QtGui.QAction(self)
        self.synchronizeAction.setText(self.tr("Synchronization"))

        self.filterGroup = QtGui.QActionGroup(self)
        self.filterGroup.addAction(self.taskListAction)
        self.filterGroup.addAction(self.channelAction)
        self.filterGroup.addAction(self.streamAction)
        self.addAction(self.taskListAction)
        self.addAction(self.channelAction)
        self.addAction(self.streamAction)

        self.addAction(self.logoutAction)
        self.addAction(self.channelsAction)
        self.addAction(self.synchronizeAction)

        self.addAction(self.newMessageAction)
        self.addAction(self.newTaskAction)

        self.connect(self.taskListAction, QtCore.SIGNAL("triggered()"), self.openTaskList);
        self.connect(self.channelAction, QtCore.SIGNAL("triggered()"), self.openChannel);
        self.connect(self.streamAction, QtCore.SIGNAL("triggered()"), self.openStream);
        
        self.connect(self.synchronizeAction, QtCore.SIGNAL("triggered()"), self.openSynchronize)
        self.connect(self.logoutAction, QtCore.SIGNAL("triggered()"), Config().windowMain.logout)

        self.connect(self.channelsAction, QtCore.SIGNAL("triggered()"), self.openChannels);
        self.connect(self.newTaskAction, QtCore.SIGNAL("triggered()"), self.openTaskEditorWindow)
        self.connect(self.newMessageAction, QtCore.SIGNAL("triggered()"), self.openMessageEditorWindow)


        self.setMode()

        #self.connect(channelsAction, QtCore.SIGNAL("triggered()"), self.workstreamer.logout);

    def setMode(self, mode = 'frontpage'):
        # Set defaults
        self.taskListAction.setVisible(True)
        self.channelAction.setVisible(True)
        self.streamAction.setVisible(True)
        self.logoutAction.setVisible(True)
        self.channelsAction.setVisible(True)
        self.synchronizeAction.setVisible(True)
        # Remove 'new task' by default
        self.newTaskAction.setVisible(False)
        self.newMessageAction.setVisible(False)

        
        if mode == "tasklist":
            self.taskListAction.setChecked(True)
            self.newTaskAction.setVisible(True)
            if Config().currentChannel != None:
                Config().windowMain.setWindowTitle(self.tr("Tasks")+": #"+str(Config().currentChannel.getName()))
        elif mode == "stream":
            self.streamAction.setChecked(True)
            self.newMessageAction.setVisible(True)
            Config().windowMain.setWindowTitle(self.tr("Stream"))
        elif mode == "channel":
            self.channelAction.setChecked(True)
            self.newMessageAction.setVisible(True)
            if Config().currentChannel != None:
                if Config.mode_workstreamer:
                    Config().windowMain.setWindowTitle(self.tr("Project")+": #"+str(Config().currentChannel.getName()))
                else:
                    Config().windowMain.setWindowTitle(self.tr("Channel")+": #"+str(Config().currentChannel.getName()))
        elif mode == "frontpage":
            self.taskListAction.setVisible(False)
            self.channelAction.setVisible(False)
            self.streamAction.setVisible(False)
            self.synchronizeAction.setVisible(False)
            self.logoutAction.setVisible(False)
            self.channelsAction.setVisible(False)
            self.newTaskAction.setVisible(False)
            self.newMessageAction.setVisible(False)
            self.hide()
            if Config.mode_workstreamer:
                Config().windowMain.setWindowTitle(self.tr("Workstreamer"))
            else:
                Config().windowMain.setWindowTitle(self.tr("Qaiku Client"))

        if Config.mode_workstreamer != True:
            self.taskListAction.setVisible(False)
            self.newTaskAction.setVisible(False)

        Config.configSet("view", str(mode))
        

    def openTaskEditorWindow(self):
        task = Ui_TaskEditor()
        task.exec_()

    def openMessageEditorWindow(self):
        dlg = Ui_MessageEditor()
        id = dlg.exec_()
        #if id > 0:
            #self.addComment(Message(id))

    def openChannels(self):
        dlg = Ui_Channels()
        dlg.exec_()
    def openChannel(self):
        Config().windowMain.showWidget('channel')
    def openStream(self):
        Config().windowMain.showWidget('stream')
    def openTaskList(self):
        Config().windowMain.showWidget('tasklist')
    def openSynchronize(self):
        dlg = Ui_Synchronize()
        dlg.exec_()
            
    
