# -*- coding: utf-8 -*-
import sys, os, time, base64, simplejson, httplib, urllib, Queue, urlparse, datetime
from threading import Thread
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

# *** qaiku json userdata fields:
#status
#apikey
#description
#url
#created_at
#profile_image_url
#name
#languages
#followers_count
#protected
#geo_enabled
#id
#screen_name

# *** channel messages struct
# created_at: "Fri Feb 19 14:57:03 +0000 2010"
# id: "1df1d670a3edd241d6711df848e3fd7f0ac574c574c"
# text: "A [very stylish costume](http://www.flickr.com/photos/bergie/3368189920/). Which reminds me, should we make some more of [these](http://www.flickr.com/photos/bergie/2845878056/)?"
# html: "A <a class="qaikulink" href="http://www.flickr.com/photos/bergie/3368189920/">very stylish costume</a>. Which reminds me, should we make some more of <a class="qaikulink" href="http://www.flickr.com/photos/bergie/2845878056/">these</a>?<br />"
# source: "Qaiku"
# lang: "en"
# data: ""
# external_url: ""
# truncated: false
# channel: "midgard"
# in_reply_to_status_id: "1df1d634a3c26601d6311dfb4a7e76e7bc9d0bed0be"
# in_reply_to_user_id: "1de05c681daca6405c611deb3f135eaaafeb080b080"
# in_reply_to_status_url: http://www.qaiku.com/go/5umc/
# favorited: false
#
#-
#geo: {

    #* type: "Point"
    #*
      #-
      #coordinates: [
          #o 24.927999
          #o 60.1633
      #]
#}
##
#-
#user: {

    #* id: "1de04e7a425656e04e711de8b8b03b7a324e879e879"
    #* name: "Henri Bergius"
    #* screen_name: "bergie"
    #* location: null
    #* description: ""
    #* profile_image_url: http://static.qaiku.com/blobs/1de/da8/8e0/1deda88e0903746da8811dea16827e2df0c54055405.jpeg
    #* url: http://www.qaiku.com/home/bergie/
    #* geo_enabled: true
    #* protected: false
    #* followers_count: 158

class QaikuData():
    def __init__(self, qaikuconn, data = None):
        self.qc = qaikuconn
        self.json = None
        if data != None:
            self.loads(data)
    
    def loads(self, data):
        self.json = simplejson.loads(str(data))
        
    def getValue(self, key):
        return self.json[key]


class QaikuChannelMessages(QaikuData):
    def __init__(self, qaikuconn, data):
        QaikuData.__init__(self, qaikuconn, data)
    def __len__(self):
        return len(self.json)


class QaikuChannels(QaikuData):
    def __init__(self, qaikuconn, data):
        QaikuData.__init__(self, qaikuconn, data)
        self.channels = self.json["channels"]
    def __len__(self):
        return len(self.channels)

            
class QaikuUser(QaikuData):
    def __init__(self, qaikuconn, data):
        QaikuData.__init__(self, qaikuconn, data)
        
    def getApiKey(self):
        return self.getValue("apikey")
        
        
class QaikuConnection():
    def __init__(self, host = "www.qaiku.com:80", apikey = None):
        # qaiku specific settings
        self.qaikuAPIKey = apikey
        
        # http connection settings
        self.setHost(host)
        self.httpUserAgent = "qaikuclient.N900"

        self.defaultSince = None
        self.source = "qaikuclient.N900"


    def setSource(self, source):
        self.source = source
        
        
    def setHost(self, host):
        url = urlparse.urlparse(host)
        if len(url.netloc) > 0:
            host = url.netloc
        self.httpHost = host
        return True

                
    def setApiKey(self, apikey):
        self.qaikuAPIKey = apikey


    def setSince(self, since):
        self.defaultSince = since

        
    def qaikuAuthenticate(self, username = None, password = None, callback = None, userdata = None):
        path = "/api/account/verify_credentials.json"
        headers = None
        if username != None:
            b64 = "Basic " + base64.b64encode(username + ":" + password)
            headers = { "Authorization": b64 }
        return self.qaikuRequest(method = "GET", path = path, headers = headers, callback = callback, userdata = userdata)

    
    def qaikuRequest(self, method, path, content_params = None, query_params = None, headers = None, callback = None, userdata = None, post_handler = None):
        if content_params == None:
            content_params = {}
        if query_params == None:
            query_params = {}
        if headers == None:
            headers = {}

        if self.qaikuAPIKey != None:
            query_params["apikey"] = str(self.qaikuAPIKey)

        headers["User-Agent"] = self.httpUserAgent
        if method == "POST":
            headers["Content-Type"] = "application/x-www-form-urlencoded"
            content_params["source"] = str(self.source)

        request = {}

        url = urlparse.urlparse(path)
        if len(url.netloc) > 0:
            request["host"] = url.netloc
            request["path"] = url.path
            request["query-raw"] = url.query
        else:
            request["host"] = self.httpHost
            request["path"] = path
            request["query-raw"] = ""

        request["method"] = method
        request["headers"] = headers
        request["content"] = content_params
        request["query"] = query_params
        request["callback"] = callback
        request["userdata"] = userdata
        request["post-handler"] = post_handler
        
        return self.processRequest(request)


    def processRequest(self, request):
        http = httplib.HTTPConnection(request["host"])
        url = request["path"]
        if len(request["query"]) > 0:
            url += "?" + urllib.urlencode(request["query"])
        if len(request["query-raw"]) > 0:
            if len(request["query"]) < 1:
                url += "?"
            else:
                url += "&"
            url += request["query-raw"]
            
        content = None
        if len(request["content"]) > 0:
            content = urllib.urlencode(request["content"])
        
        http.request(method = request["method"], url = url, body = content, headers = request["headers"])
        response = http.getresponse()
        request["status"] = response.status
        request["reason"] = response.reason
        request["data"] = response.read()
        http.close()

        if request["post-handler"] != None:
            request["post-handler"](request)

        if request["callback"] != None:
            request["callback"](request)
            
        return request

        
    # get data
    def qaikuGet(self, path, query_params = None, callback = None, userdata = None, post_handler = None):
        return self.qaikuRequest(callback = callback, method = "GET", path = path, query_params = query_params, userdata = userdata, post_handler = post_handler)

        
    # post data
    def qaikuPost(self, path, content_params = None, query_params = None, callback = None, userdata = None, post_handler = None):
        return self.qaikuRequest(callback = callback, method = "POST", path = path, content_params = content_params, query_params = query_params, userdata = userdata, post_handler = post_handler)

        
    # read message
    def qaikuReadMessage(self, id, callback = None, userdata = None):
        path = "/api/statuses/show/"+str(id)+".json"
        return self.qaikuGet(callback = callback, path = path, userdata = userdata)


    # get channels (of type)
    def qaikuGetChannels(self, channel_type = None, callback = None, userdata = None):
        path = "/api/channels/my.json"
        query_params = {}
        if channel_type != None:
            query_params["type"] = str(channel_type)
        return self.qaikuGet(callback = callback, path = path, query_params = query_params, userdata = userdata, post_handler = self.qaikuGetChannelsPost)


    def qaikuGetChannelsPost(self, request):
        if request["status"] == 200:
            request["channels"] = QaikuChannels(self, request["data"])

        
    # post new qaiku message
    def qaikuPostMessage(self, message, channel = None, lang = "en", in_reply_to_status_id = None, data = None, external_url = None, callback = None, userdata = None):
        path = "/api/statuses/update.json"
        content_params = {}
        if channel != None:
            content_params["channel"] = str(channel)
        if lang != None:
            content_params["lang"] = lang
        if in_reply_to_status_id != None:
            content_params["in_reply_to_status_id"] = in_reply_to_status_id
        if data != None:
            content_params["data"] = data
        content_params["status"] = str(message)
        
        return self.qaikuPost(callback = callback, path = path, content_params = content_params, userdata = userdata, post_handler = self.qaikuPostMessagePost)


    def qaikuPostMessagePost(self, request):
        if request["status"] == 200:
            try:
                request["qdata"] = QaikuData(self, request["data"])
            except:
                request["qdata"] = QaikuData(self, "[]")


    # get messages from channel
    def qaikuGetChannelMessages(self, channel = None, since = None, page = None, lang = None, callback = None, userdata = None):
        if channel != None:
            path = "/api/statuses/mainchannel_timeline/"+str(channel)+".json"
        else:
            path = "/api/statuses/user_timeline.json"
        query_params = {}
        if since != None:
            query_params["since"] = since.isoformat()
        elif self.defaultSince != None:
            query_params["since"] = self.defaultSince.isoformat()
        if page != None:
            query_params["page"] = page
        if lang != None:
            query_params["lang"] = lang
        return self.qaikuGet(callback = callback, path = path, query_params = query_params, userdata = userdata, post_handler = self.qaikuGetChannelMessagesPost)


    def qaikuGetChannelMessagesPost(self, request):
        if request["status"] == 200:
            try:
                request["channel_messages"] = QaikuChannelMessages(self, request["data"])
            except:
                request["channel_messages"] = QaikuChannelMessages(self, "[]")


    # get messages from channel
    def qaikuGetMessageComments(self, message, since = None, page = None, lang = None, callback = None, userdata = None):
        path = "/api/statuses/replies/"+str(message)+".json"
        query_params = {}
        if since != None:
            query_params["since"] = since.isoformat()
        elif self.defaultSince != None:
            query_params["since"] = self.defaultSince.isoformat()
        if page != None:
            query_params["page"] = page
        if lang != None:
            query_params["lang"] = lang
        return self.qaikuGet(callback = callback, path = path, query_params = query_params, userdata = userdata, post_handler = self.qaikuGetMessageCommentsPost)


    def qaikuGetMessageCommentsPost(self, request):
        if request["status"] == 200:
            try:
                request["message_comments"] = QaikuChannelMessages(self, request["data"])
            except:
                request["channel_messages"] = QaikuChannelMessages(self, "[]")

#    def setDoneCallback(self, callback):
#        self.httpDoneCallback = callback


    def qaikuSynchronize(self):
        return
        
        

