# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui
import time
from datetime import datetime
from dateutil.relativedelta import *
import Queue

from config import Config
from channel import Channel
from person import Person

from ui_button import Ui_PushButton
from ui_usereditor import Ui_UserEditor
from qaikusynchronize import QaikuSynchronization


class Ui_Synchronize(QtGui.QDialog):
    def __init__(self):
        QtGui.QDialog.__init__(self)

        self.setObjectName("Synchronize")
        self.setWindowTitle(self.tr("Synchronization options"))
        
        self.layout = QtGui.QGridLayout(self)
        self.progressInfo = QtGui.QLabel("")
        self.layout.addWidget(self.progressInfo, 0, 0, 1, 3)

        self.loading = QtGui.QLabel()
        self.movie = QtGui.QMovie("data/loading.gif")
        self.loading.setMovie(self.movie)
        self.layout.addWidget(self.loading, 1, 0)

        self.progressBar = QtGui.QProgressBar()
        self.progressBar.setValue(0)
        self.layout.addWidget(self.progressBar, 1, 1)
        
        self.syncButton = QtGui.QPushButton(self.tr("Synchronize now"))
        self.layout.addWidget(self.syncButton, 1, 2)
        QtCore.QObject.connect(self.syncButton, QtCore.SIGNAL("clicked()"), self.synchronize)
        #self.layout.setStretchFactor(button, 0);

        self.checkUsers = QtGui.QCheckBox(self.tr("Synchronize users"))
        self.checkUsers.setCheckState(QtCore.Qt.Checked)
        Config.configSet("sync/users/enabled", 1)
        #if Config.configIs("sync/users/enabled", 1):
            #self.checkUsers.setCheckState(QtCore.Qt.Checked)
        #else:
            #self.checkUsers.setCheckState(QtCore.Qt.Unchecked)
        #Config().sync.enableSection("Users", False)
        QtCore.QObject.connect(self.checkUsers, QtCore.SIGNAL("stateChanged(int)"), self.selectCheckUsers)
        self.layout.addWidget(self.checkUsers, 2, 0, 1, 3)
        self.checkUsers.hide()

        self.selectSince = Ui_PushButton()
        self.selectSince.setSelectCallback(self.selectSelectSince)
        self.selectSince.setText(self.tr("Limit synchronized messages since"))
        self.selectSince.setInfo(Config.configGetString("sync/channels/since"))
        self.selectSince.createMenu(self.tr("Limit synchronized messages since"))
        #self.selectSince.addMenuItem(self.tr("Automatic"))
        self.selectSince.addMenuItem(self.tr("All"))
        #self.selectSince.addMenuItem(self.tr("One hour"))
        self.selectSince.addMenuItem(self.tr("One day"))
        self.selectSince.addMenuItem(self.tr("One week"))
        self.selectSince.addMenuItem(self.tr("Don't synchronize"))
        self.layout.addWidget(self.selectSince, 3, 0, 1, 3)
        
        t = datetime.now() + relativedelta(days=-1)
        Config().sync.setSince(t)
        
        self.ready = 0
        self.timer = QtCore.QTimer(self)
        QtCore.QObject.connect(self.timer, QtCore.SIGNAL("timeout()"), self.timerEvent)
        self.timerEvent()
        self.timer.start(500)
        

    def selectCheckUsers(self, value):
        if value == QtCore.Qt.Checked:
            Config.configSet("sync/users/enabled", 1)
        else:
            Config.configSet("sync/users/enabled", 0)


    def selectSelectSince(self, value, widget):
        Config.configSet("sync/channels/since", str(value))


    def synchronize(self):
        self.ready = 3
        #Config().sync.qaikuAuthenticate(callback = self.authorized)

        Config().sync.enableSection("users", True)
        if Config.configIs("sync/users/enabled", 0):
            Config().sync.enableSection("users", False)

        value = Config.configGetString("sync/channels/since")
        Config().sync.enableSection("channels", True)
        t = None
        if value == self.tr("Automatic"):
            pass
        elif value == self.tr("All"):
            pass
        elif value == self.tr("One hour"):
            t = datetime.now() + relativedelta(hours=-1)
        elif value == self.tr("One day"):
            t = datetime.now() + relativedelta(days=-1)
        elif value == self.tr("One week"):
            t = datetime.now() + relativedelta(weeks=-1)
        elif value == self.tr("Don't synchronize"):
            Config().sync.enableSection("channels", False)
        Config().sync.setSince(t) 

        self.authorized(None)


    def authorized(self, request):
        print "start sync"
        #if request["status"] == 200:
        if True:
            Config().sync.synchronize()
        else:
            ue = Ui_UserEditor(Config().currentPerson)
            if ue.exec_() == 1:
                person = Config().currentPerson
                person = Person(str(person.getLogin()))
                Config().sync.setApiKey(person.getApiKey())
                Config().currentPerson = person
                self.synchronize()


    def timerEvent(self):
        status = Config().sync.getStatus()
        
        if status["progress"] >= 100 or status["wait"] == False:
                self.movie.stop()
                self.syncButton.setDisabled(False)
                self.selectSince.setDisabled(False)
        else:
                self.movie.start()
                self.syncButton.setDisabled(True)
                self.selectSince.setDisabled(True)

        info = status["major"]
        if len(status["minor"]) > 0:
            info += ": " + status["minor"]
        self.progressInfo.setText(info)
        self.progressBar.setValue(int(status["progress"]))

        if status["progress"] >= 100 and self.ready > 0:
            self.ready -= 1
            if self.ready < 1:
                self.done(0)

