# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui


class Ui_ListLabel(QtGui.QLabel):
    def __init__(self, parent = None):
        QtGui.QLabel.__init__(self, parent)
        
        self.has_text = False
        self.icon = None
        self.icon_x = 0
        self.icon_y = 0
        self.bg = None
        self.bg_drawlast = False


    def setPixmap(self, filename, offset_x = 0, offset_y = 0):
        QtGui.QLabel.setPixmap(self, QtGui.QPixmap(filename))
        #self.icon = QtGui.QPixmap(filename)
        #self.icon_x = offset_x
        #self.icon_y = offset_y


    def setBackground(self, filename, drawlast = False):
        self.bg = QtGui.QPixmap(filename)
        self.bg_drawlast = drawlast
        

    def setText(self, text):
        QtGui.QLabel.setText(self, text)
        self.has_text = True

        
    #def paintEvent(self, event):
        #QtGui.QLabel.paintEvent(self, event)
        #painter = QtGui.QPainter(self)

        #if self.bg != None and self.bg_drawlast == False:
            #painter.drawPixmap(0, 0, self.bg)
            
        #if self.icon != None:
            #painter.drawPixmap(self.icon_x, self.icon_y, self.icon)

        #if self.bg != None and self.bg_drawlast == True:
            #painter.drawPixmap(0, 0, self.bg)

        #if self.has_text:
            #pass
        
        #painter.end()


    #def sizeHint(self):
        #hint = QtGui.QLabel.sizeHint(self)
        #if self.icon != None:
            #hint.setWidth(self.icon.width())
            #hint.setHeight(self.icon.height())
        #if self.bg != None:
            #hint.setWidth(self.bg.width())
            #hint.setHeight(self.bg.height())
        #return hint

        
class Ui_ListWidget(QtGui.QWidget):
    def __init__(self, parent = None, width = 0, callback = None, userdata = None):
        QtGui.QWidget.__init__(self, parent)
        self.layout = QtGui.QHBoxLayout(self)
        self.setContentsMargins(0, 0, 0, 0)

        self.leftWidget = QtGui.QWidget(self)
        self.leftWidget.setContentsMargins(0, 0, 0, 0)
        self.left = QtGui.QVBoxLayout(self.leftWidget)
        self.layout.insertWidget(0, self.leftWidget, 0)
        self.middleWidget = QtGui.QWidget(self)
        self.middleWidget.setContentsMargins(0, 0, 0, 0)
        self.middle = QtGui.QVBoxLayout(self.middleWidget)
        self.layout.insertWidget(1, self.middleWidget, 100)
        self.rightWidget = QtGui.QWidget(self)
        self.rightWidget.setContentsMargins(0, 0, 0, 0)
        self.right = QtGui.QVBoxLayout(self.rightWidget)
        self.layout.insertWidget(2, self.rightWidget, 0)
        
        self.label = None
        self.icon = None
        
        # this keeps track of mouse events, whether or not the task was actually clicked
        self.enableClick = True
        self.clicked = callback
        self.userdata = userdata

        self.borderWidthNormal = 1
        self.borderWidthHilight = 1
        self.borderColorNormal = QtGui.QColor(48, 48, 48)
        self.borderColorHilight = QtGui.QColor(107, 211, 255)
        self.color1Normal = QtGui.QColor(64, 64, 64)
        self.color2Normal = QtGui.QColor(24, 24, 24)
        self.color1Hilight = QtGui.QColor(32, 160, 200)
        self.color2Hilight = QtGui.QColor(16, 117, 189)
        self.cornerRadiusNormal = 10.0
        self.cornerRadiusHilight = 10.0
        self.borderWidth = self.borderWidthNormal
        self.borderColor = self.borderColorNormal
        self.color1 = self.color1Normal
        self.color2 = self.color2Normal
        self.cornerRadius = self.cornerRadiusNormal

        self.reset()
        self.setWidth(width)

        
    def setWidth(self, width):
        self.width = width
        if width > 0:
            self.setMinimumSize(width, 0)
            self.setSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Preferred)

        
    def reset(self):
        self.borderWidth = self.borderWidthNormal
        self.borderColor = self.borderColorNormal
        self.color1 = self.color1Normal
        self.color2 = self.color2Normal
        self.cornerRadius = self.cornerRadiusNormal


    def setFlat(self, flat):
        if flat == True:
            self.color1Normal = QtGui.QColor(24, 24, 24)
            self.color2Normal = QtGui.QColor(24, 24, 24)
            self.color1Hilight = QtGui.QColor(16, 117, 189)
            self.color2Hilight = QtGui.QColor(16, 117, 189)
        else:
            self.color1Normal = QtGui.QColor(64, 64, 64)
            self.color2Normal = QtGui.QColor(24, 24, 24)
            self.color1Hilight = QtGui.QColor(32, 160, 200)
            self.color2Hilight = QtGui.QColor(16, 117, 189)
        self.reset()
        self.update()


    def setBorder(self, border = None, color = None, radius = None):
        if border != None:
            self.borderWidthNormal = border
        if color != None:
            self.borderColorNormal = color
        if radius != None:
            self.cornerRadiusNormal = radius
        self.dehilight()

        
    def setColors(self, color1 = None, color2 = None):
        if color1 != None:
            self.color1Normal = color1
        if color2 != None:
            self.color2Normal = color2
        self.deh
        ilight()

            
    def setText(self, text):
        if self.label == None:
            self.label = Ui_ListLabel(self)
            self.label.setOpenExternalLinks(True)
            self.label.setWordWrap(True)
            self.label.setTextInteractionFlags(QtCore.Qt.NoTextInteraction)
            #self.label.setStyleSheet("a { background-color: red; }")
            self.middle.insertWidget(0, self.label, 100)
        self.label.setText(text)


    def setIcon(self, filename, background = None, offset_x = 0, offset_y = 0):
        if self.icon == None:
            self.icon = Ui_ListLabel(self)
            self.left.insertWidget(0, self.icon, 0, QtCore.Qt.AlignTop)
        self.icon.setPixmap(filename, offset_x, offset_y)
        if background != None:
            self.icon.setBackground(background, True)


    def setIconMode(self, value):
        if value == True:
            self.middleWidget.hide()
            self.rightWidget.hide()
            self.layout.setAlignment(self.leftWidget, QtCore.Qt.AlignBottom)
        else:
            self.middleWidget.show()
            self.rightWidget.show()


    def addWidgetLeft(self, widget):
        self.left.addWidget(widget)


    def addWidgetRight(self, widget, stretch = 0, align = QtCore.Qt.AlignTop):
        self.right.addWidget(widget, stretch, align)


    def addWidgetBottom(self, widget, stretch = 0, align = QtCore.Qt.AlignLeft):
        self.middle.addWidget(widget, stretch, align)


    def paintEvent(self, event):
        w = self.rect().width() - self.borderWidth
        h = self.rect().height() - self.borderWidth
        
        if self.borderWidth > 0:
            x = y = self.borderWidth - 1
        else:
            x = y = 0

        painter = QtGui.QPainter(self)
        painter.fillRect(self.rect(), QtCore.Qt.transparent)

        if self.borderWidth > 0:
            pen = QtGui.QPen(self.borderColor)
            pen.setWidth(self.borderWidth)
            painter.setPen(pen)
        else:
            pen = QtGui.QPen(QtCore.Qt.transparent)
            pen.setWidth(0)
            painter.setPen(pen)
            
        gradient = QtGui.QLinearGradient(0, 0, 0, 30)
        gradient.setColorAt(0, self.color1)
        gradient.setColorAt(1, self.color2)
        brush = QtGui.QBrush(gradient)
        painter.setBrush(brush)
        painter.drawRoundedRect(x, y, w, h, self.cornerRadius, 0.0)
        
        painter.end()

        QtGui.QWidget.paintEvent(self, event)


    def hilight(self):
        self.borderWidth = self.borderWidthHilight
        self.borderColor = self.borderColorHilight
        self.color1 = self.color1Hilight
        self.color2 = self.color2Hilight
        self.cornerRadius = self.cornerRadiusHilight
        self.update()

        
    def dehilight(self):
        self.reset()
        self.update()


    def mouseMoveEvent(self, event):
        if event.x() < 0 or event.y() < 0:
            self.enableClick = False


    def mouseReleaseEvent(self, event):
        if self.clicked != None:
            self.dehilight()
            if self.enableClick == True:
                self.clicked(self, self.userdata)


    def mousePressEvent(self, event):
        if self.clicked != None:
            self.enableClick = True
            self.hilight()

        
class Ui_List(QtGui.QScrollArea):
    def __init__(self, parent = None, horizontal = True):
        QtGui.QScrollArea.__init__(self, parent)

        self.widget = QtGui.QWidget(self)
        if horizontal:
            self.layout = QtGui.QVBoxLayout(self.widget)
            self.widget.setSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Maximum)
            self.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
            self.layout.setSpacing(0)
        else:
            self.layout = QtGui.QHBoxLayout(self.widget)
            self.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
            self.widget.setSizePolicy(QtGui.QSizePolicy.Maximum, QtGui.QSizePolicy.Preferred)
            self.layout.setSpacing(8)
                
        self.setContentsMargins(0, 0, 0, 0)
        self.layout.setContentsMargins(0, 0, 0, 0)
        self.widget.setContentsMargins(0, 0, 0, 0)

        self.setWidget(self.widget)
        self.setWidgetResizable(True)
        self.widgets = []
       


    def setSpacing(self, spacing):
        self.layout.setSpacing(spacing)


    def __len__(self):
        return self.layout.count()


    def addLabel(self, text, icon = None):
        widget = Ui_ListWidget(self)
        widget.setText(text)
        if icon != None:
            widget.setIcon(icon)
        self.layout.addWidget(widget)
        
        
    def addWidget(self, widget, index = None):
        widget.setParent(self.widget)

        if index != None:
            self.layout.insertWidget(index, widget)
            self.widgets.insert(index, widget)
        else:
            self.layout.addWidget(widget)
            self.widgets.append(widget)

        #print self.sizeHint().height()
#        self.resize(self.sizeHint())


    def clear(self):
        for widget in self.widgets:
            self.layout.removeWidget(widget)
            widget.deleteLater()
        self.widgets = []
        

    def pop(self, index):
        self.layout.removeWidget(self.widgets[index])
        self.widgets[index].deleteLater()
        self.widgets.pop(index)
        
        
    def debugprint(self):
        w = self.widget.sizeHint().width()
        h = self.widget.sizeHint().height()
        rest = ""
        for wid in self.widgets:
            ww = str(wid.sizeHint().width())
            wh = str(wid.sizeHint().height())
            rest += ww+"*"+wh+", "

        print w, h, rest


    def count(self):
        return self.layout.count()

    #def clear(self):


