#include <QtGui>
#include <q-extras/qemaemo5notification.h>

int main (int argc, char **argv)
{
    QApplication::setApplicationName("Sample app");
    QApplication::setOrganizationName("Venemo");
    QeMaemo5Notification::setApplicationIcon("general_bluetooth");

    QApplication app(argc, argv);
    QMainWindow w;
    QPushButton b("Push me", &w);
    QeMaemo5Notification n("This is a test", &w);

    QObject::connect(&n, SIGNAL(clicked()), &w, SLOT(show()));
    QObject::connect(&n, SIGNAL(closed()), &app, SLOT(quit()));
    QObject::connect(&b, SIGNAL(clicked()), &w, SLOT(hide()));
    QObject::connect(&b, SIGNAL(clicked()), &n, SLOT(show()));

    b.setFixedSize(200, 70);
    n.addHint(QeStringPair("led-pattern", "PatternCommunicationEmail"));
    n.show();

    QDBusMessage m = QDBusMessage::createMethodCall("com.nokia.mediaplayer", "/com/nokia/osso/mediaplayer", "com.nokia.mediaplayer", "open_mp_now_playing");
    QeMaemo5Notification::information("Click me!",
                                      "Media",
                                      10000,
                                      &m,
                                      QList<QeStringPair>(),
                                      "tasklaunch_media_player");

    return app.exec();
}
