#ifndef QEMAEMO5NOTIFICATION_H
#define QEMAEMO5NOTIFICATION_H

//----------
// Provides a Qt abstraction of Maemo5's SMS/E-mail-style notifications.
//----------

#include <QtGui>
#include <QtDBus/QtDBus>

#define QE_MAEMO5_NOTIFICATION_DBUS_INTERFACE "net.venemo.qextrasnotification"

typedef struct _HildonNotification HildonNotification;
typedef struct _NotifyNotification NotifyNotification;
typedef char gchar;
typedef void* gpointer;
typedef QPair<QString, QString> QeStringPair;

class QeMaemo5Notification : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "net.venemo.qextrasnotification") // We need this here because it won't accept the macro.

    HildonNotification *notification;
    QString id;
    QString _text;
    QString _title;
    QString _icon;
    int _timeout;
    QList<QDBusMessage> _dbusMessages;
    bool _isVisible;

    static void notification_closed(NotifyNotification* notification, gpointer user_data);

public:
    static const int EXPIRES_NEVER;
    static const int DEFAULT_TIMEOUT;
    static const QString DEFAULT_ICON;
    static const QString APPLICATION_ICON_SETTING_KEY;

    static const QString applicationIcon();
    static void setApplicationIcon(const QString &icon);

    static void information(const QString &text, const QString &title = QApplication::applicationName(), int timeout = DEFAULT_TIMEOUT, const QDBusMessage *message = 0, const QList<QeStringPair> &hints = QList<QeStringPair>(), const QString &icon = applicationIcon());
    static void information(const QString &text, const QString &title, int timeout, const QString &icon);
    static void nonExpiringInformation(const QString &text, const QString &title = QApplication::applicationName(), const QDBusMessage *message = 0, const QList<QeStringPair> &hints = QList<QeStringPair>(), const QString &icon = applicationIcon());
    static void nonExpiringInformation(const QString &text, const QString &title, const QString &icon);

    explicit QeMaemo5Notification(const QString &text, QObject *parent = 0, const QString &title = QApplication::applicationName(), int timeout = DEFAULT_TIMEOUT, const QList<QeStringPair> &hints = QList<QeStringPair>(), const QString &icon = applicationIcon());
    ~QeMaemo5Notification();

    bool isVisible();
    QString text();
    QString title();
    QString icon();
    void setText(const QString &value);
    void setTitle(const QString &value);
    void setIcon(const QString &value);
    int timeout();
    void setTimeout(int value);
    void addDbusAction(const QDBusMessage &value);
    void clearDbusActions();
    void addHint(const QeStringPair &hint);
    void clearHints();


Q_SIGNALS:
    void clicked();
    void closed();

public Q_SLOTS:
    Q_SCRIPTABLE int clicked_you_now();
    void show();
    void hide();
};

#endif // QEMAEMO5NOTIFICATION_H
