#include "qetimerrunnable.h"

QeTimerRunnable::QeTimerRunnable(QTimer *timer, int interval)
    : QRunnable(), _timer(timer), _interval(interval)
{
    if (timer == NULL)
        qDebug() << "Hey, the given timer is null!";
}

void QeTimerRunnable::run()
{
    _timer->start(_interval);
}

void QeTimerRunnable::createAndRunOnSeparateThread(QTimer *timer, int interval, int priority)
{
    QeTimerRunnable *runnable = new QeTimerRunnable(timer, interval);
    QThreadPool::globalInstance()->start(runnable, priority);
}
