#!/usr/bin/python
#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import evas
import ecore
import ecore.evas
import terra.ui.layout

ee = ecore.evas.SoftwareX11(w=300, h=300)

canvas = ee.evas

bg = canvas.Rectangle(color=(0, 0, 0, 255))
bg.size = canvas.size
bg.show()
ee.data["bg"] = bg

colors = (
    (255, 0, 0, 255),
    (0, 255, 0, 255),
    (0, 0, 255, 255),
    (255, 255, 0, 255),
    (0, 255, 255, 255),
    (255, 0, 255, 255),
    )

children = []
for c in colors * 5:
    o = canvas.Rectangle(size=(30, 30), color=c)
    o.show()
    children.append(o)

grid = terra.ui.layout.Grid(canvas, children=children, halign=0.5, valign=0.5)
grid.size = canvas.size
grid.show()
ee.data["grid"] = grid

def on_resize(ee):
    ee.data["bg"].size = ee.evas.size
    ee.data["grid"].size = ee.evas.size
ee.callback_resize = on_resize

def on_key_down(obj, event):
    grid = ee.data["grid"]
    if event.keyname == "c":
        grid.clear()
    elif event.keyname == "i":
        c = grid.color_get()[0]
        c += 10
        if c > 255:
            c = 255
        grid.color_set(c, c, c, c)
    elif event.keyname == "o":
        c = grid.color_get()[0]
        c -= 10
        if c < 0:
            c = 0
        grid.color_set(c, c, c, c)
    elif event.keyname == "Escape":
        ecore.main_loop_quit()
bg.focus = True
bg.on_key_down_add(on_key_down)


ee.show()
ecore.main_loop_begin()
