#!/usr/bin/python
#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import evas
import ecore
import ecore.evas
import terra.ui.layout

ee = ecore.evas.SoftwareX11(w=300, h=300)

canvas = ee.evas

bg = canvas.Rectangle(color=(0, 0, 0, 255))
bg.size = canvas.size
bg.show()
ee.data["bg"] = bg

colors = (
    (255, 0, 0, 255),
    (0, 255, 0, 255),
    (0, 0, 255, 255),
    (255, 255, 0, 255),
    (0, 255, 255, 255),
    (255, 0, 255, 255),
    )

children = []
for c in colors:
    o = canvas.Rectangle(size=(30, 30), color=c)
    o.show()
    children.append(o)

vbox = terra.ui.layout.VBox(canvas, children=children, halign=0.5, valign=0.5)
vbox.size = canvas.size
vbox.show()
ee.data["vbox"] = vbox

def on_resize(ee):
    ee.data["bg"].size = ee.evas.size
    ee.data["vbox"].size = ee.evas.size
ee.callback_resize = on_resize

def on_key_down(obj, event):
    vbox = ee.data["vbox"]
    if event.keyname == "c":
        vbox.clear()
    elif event.keyname == "i":
        c = vbox.color_get()[0]
        c += 10
        if c > 255:
            c = 255
        vbox.color_set(c, c, c, c)
    elif event.keyname == "o":
        c = vbox.color_get()[0]
        c -= 10
        if c < 0:
            c = 0
        vbox.color_set(c, c, c, c)
    elif event.keyname == "Escape":
        ecore.main_loop_quit()
bg.focus = True
bg.on_key_down_add(on_key_down)

ee.show()
ecore.main_loop_begin()
