#!/usr/bin/env python
#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import sys
import threading
import ecore
import time

from terra.core.model import Model
from terra.core.threaded_model import ThreadedModelFolder


def print_thread(msg):
    print "[%s]:" % threading.currentThread().getName(), msg
    sys.stdout.flush()


class MyModel(Model):
    def __init__(self, name, parent):
        Model.__init__(self, name)
        self.parent = parent


class MyFolder(ThreadedModelFolder):
    def __init__(self):
        ThreadedModelFolder.__init__(self, "thr_test")
        self.count = 12

    def _add_more(self):
        print_thread("adding more items to the list ...")
        l = [MyModel("threaded-%d" % self.count, self),
             MyModel("threaded-%d" % (self.count-1), self),
             MyModel("threaded-%d" % (self.count-2), self)]
        self.count -= 3
        self.extend(l)

    def do_load(self):
        print_thread("starting ...")
        while self.count > 0 and not self.must_die:
            self._add_more()
            time.sleep(0.1)
        print_thread("finishing ...")


def load_folder(mf):
    mf.load()
    return False


def print_folder(mf):
    print_thread('len = %d, children = %r' % (len(mf.children), mf.children))
    print_thread('---------------------------------------------------')


if __name__ == "__main__":
    mf = MyFolder()
    mf.changed_callback_add(print_folder)

    ecore.idler_add(load_folder, mf)
    ecore.main_loop_begin()
